/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackCountPane;
import reliquary.util.InventoryHelper;

public class DynamicChargePane
extends Component {
    private final Item mainItem;
    private final ItemStackCountPane chargeablePane;
    private final Function<ItemStack, ItemStack> getChargeItem;
    private final Function<ItemStack, Integer> getCount;

    public DynamicChargePane(Item mainItem, UnaryOperator<ItemStack> getChargeItem, Function<ItemStack, Integer> getCount) {
        this.mainItem = mainItem;
        this.getChargeItem = getChargeItem;
        this.getCount = getCount;
        this.chargeablePane = new ItemStackCountPane(ItemStack.EMPTY, 0);
    }

    @Override
    public int getHeightInternal() {
        return this.chargeablePane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.chargeablePane.getWidth();
    }

    @Override
    public int getPadding() {
        return this.chargeablePane.getPadding();
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack itemStack = InventoryHelper.getCorrectItemFromEitherHand((Player)player, this.mainItem);
        if (itemStack.isEmpty()) {
            return;
        }
        this.chargeablePane.setItemStack(this.getChargeItem.apply(itemStack));
        this.chargeablePane.setCount(this.getCount.apply(itemStack));
        this.chargeablePane.render(guiGraphics, x, y);
    }
}

