/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import reliquary.Reliquary;
import reliquary.block.ApothecaryMortarBlock;
import reliquary.block.tile.ApothecaryMortarBlockEntity;
import reliquary.compat.jade.provider.CachedBodyDataProvider;
import reliquary.init.ModItems;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionIngredient;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class DataProviderMortar
extends CachedBodyDataProvider
implements IServerDataProvider<BlockAccessor> {
    private static final String PESTLE_USED_COUNTER = "pestleUsedCounter";
    private PotionContents potionContents;

    @Override
    public List<List<IElement>> getWailaBodyToCache(IElementHelper helper, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity;
        ArrayList<List<IElement>> lines = new ArrayList<List<IElement>>();
        if (!(accessor.getBlock() instanceof ApothecaryMortarBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof ApothecaryMortarBlockEntity)) {
            return lines;
        }
        ApothecaryMortarBlockEntity mortar = (ApothecaryMortarBlockEntity)blockEntity;
        NonNullList<ItemStack> ingredientStacks = mortar.getItemStacks();
        ArrayList<IElement> ingredients = new ArrayList<IElement>();
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack ingredientStack : ingredientStacks) {
            if (ingredientStack.isEmpty()) continue;
            ingredients.add(helper.item(ingredientStack));
            PotionHelper.getIngredient(ingredientStack).ifPresent(potionIngredients::add);
        }
        lines.add(ingredients);
        this.potionContents = PotionHelper.combineIngredients(potionIngredients);
        ArrayList<Component> effectTooltips = new ArrayList<Component>();
        if (this.potionContents.hasEffects()) {
            int pestleUsedCounter = accessor.getServerData().getInt(PESTLE_USED_COUNTER);
            lines.add(this.createPestleProgress(helper, pestleUsedCounter));
            TooltipBuilder.of(effectTooltips, Item.TooltipContext.of((Level)mortar.getLevel())).potionEffects(this.potionContents);
            lines.addAll(effectTooltips.stream().map(text -> List.of(helper.text(text))).toList());
        }
        return lines;
    }

    public List<IElement> createPestleProgress(IElementHelper helper, int pestleUsedCounter) {
        ItemStack stack = ModItems.POTION_ESSENCE.get().getDefaultInstance();
        PotionHelper.addPotionContentsToStack(stack, this.potionContents);
        return List.of(helper.progress((float)pestleUsedCounter / 5.0f), helper.item(stack));
    }

    @Override
    public List<List<IElement>> updateCache(IElementHelper helper, BlockAccessor accessor, List<List<IElement>> cached) {
        if (cached.size() > 1) {
            int pestleUsedCounter = accessor.getServerData().getInt(PESTLE_USED_COUNTER);
            cached.set(1, this.createPestleProgress(helper, pestleUsedCounter));
        }
        return cached;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        ApothecaryMortarBlockEntity be = (ApothecaryMortarBlockEntity)blockAccessor.getBlockEntity();
        compoundTag.putInt(PESTLE_USED_COUNTER, be.getPestleUsedCounter());
    }

    public ResourceLocation getUid() {
        return Reliquary.getRL("mortar");
    }
}

