/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import reliquary.Reliquary;
import reliquary.block.PedestalBlock;
import reliquary.block.tile.PedestalBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class DataProviderPedestal
implements IBlockComponentProvider {
    private static final ResourceLocation PEDESTAL_UID = Reliquary.getRL("pedestal");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        if (!(accessor.getBlock() instanceof PedestalBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof PedestalBlockEntity)) {
            return;
        }
        PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
        BlockState pedestalState = accessor.getBlockState();
        if (Boolean.TRUE.equals(pedestalState.getValue((Property)PedestalBlock.ENABLED))) {
            tooltip.add((Component)Component.translatable((String)"waila.reliquary.pedestal.state", (Object[])new Object[]{Component.translatable((String)"waila.reliquary.pedestal.state.on").withStyle(ChatFormatting.GREEN)}));
            if (pedestal.switchedOn()) {
                tooltip.add((Component)Component.translatable((String)"waila.reliquary.pedestal.switched_on"));
            }
            if (pedestal.isPowered()) {
                tooltip.add((Component)Component.translatable((String)"waila.reliquary.pedestal.redstone_powered"));
            }
            if (!pedestal.getOnSwitches().isEmpty()) {
                for (long loc : pedestal.getOnSwitches()) {
                    BlockPos pos = BlockPos.of((long)loc);
                    tooltip.add((Component)Component.translatable((String)"waila.reliquary.pedestal.remote_at", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"waila.reliquary.pedestal.state", (Object[])new Object[]{Component.translatable((String)"waila.reliquary.pedestal.state.off").withStyle(ChatFormatting.RED)}));
        }
    }

    public ResourceLocation getUid() {
        return PEDESTAL_UID;
    }
}

