/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.handler.ClientEventHandler;
import reliquary.init.ModItems;
import reliquary.network.FortuneCoinTogglePressedPayload;

public class FortuneCoinToggler {
    private static FortuneCoinToggler coinToggler = new FortuneCoinToggler();

    public static void setCoinToggler(FortuneCoinToggler toggler) {
        coinToggler = toggler;
    }

    public static void handleKeyInputEvent(ClientTickEvent.Pre event) {
        if (ClientEventHandler.FORTUNE_COIN_TOGGLE_KEYBIND.consumeClick()) {
            coinToggler.findAndToggle();
        }
    }

    public boolean findAndToggle() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        for (int slot = 0; slot < player.getInventory().items.size(); ++slot) {
            ItemStack stack = (ItemStack)player.getInventory().items.get(slot);
            if (stack.getItem() != ModItems.FORTUNE_COIN.get()) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new FortuneCoinTogglePressedPayload(FortuneCoinTogglePressedPayload.InventoryType.MAIN, slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ModItems.FORTUNE_COIN.get().toggle(stack);
            return true;
        }
        if (((ItemStack)player.getInventory().offhand.getFirst()).getItem() == ModItems.FORTUNE_COIN.get()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FortuneCoinTogglePressedPayload(FortuneCoinTogglePressedPayload.InventoryType.OFF_HAND, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ModItems.FORTUNE_COIN.get().toggle((ItemStack)player.getInventory().offhand.getFirst());
            return true;
        }
        return false;
    }
}

