/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.init.ModItems;
import reliquary.item.PotionItemBase;
import reliquary.util.potions.PotionHelper;

public class PotionItem
extends PotionItemBase {
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (PotionHelper.hasPotionContents(stack)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (!level.isClientSide) break block6;
            }
            return stack;
        }
        PotionHelper.applyEffectsToEntity((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY), (Entity)player, null, (LivingEntity)player);
        if (!player.isCreative()) {
            stack.shrink(1);
            ItemStack emptyVial = new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
            if (stack.getCount() <= 0) {
                return emptyVial;
            }
            player.getInventory().add(emptyVial);
        }
        return stack;
    }
}

