/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Config;

public class PedestalBucketWrapper
implements IPedestalActionItemWrapper {
    private static final int UNSUCCESSFUL_TRIES_TO_CLEAN_QUEUE = 5;
    private final List<BlockPos> queueToDrain = new ArrayList<BlockPos>();
    private int unsuccessfulTries = 0;

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        int bucketRange;
        BlockPos pos = pedestal.getBlockPosition();
        if (!this.milkCows(level, pedestal, pos, bucketRange = ((Integer)Config.COMMON.blocks.pedestal.bucketWrapperRange.get()).intValue(), stack) && !this.drainLiquid(level, pedestal, pos, bucketRange)) {
            pedestal.setActionCoolDown(2 * (Integer)Config.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
            return;
        }
        pedestal.setActionCoolDown((Integer)Config.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private boolean drainLiquid(Level level, IPedestal pedestal, BlockPos pos, int bucketRange) {
        if (this.queueToDrain.isEmpty()) {
            this.updateQueueToDrain(level, pos, bucketRange);
        }
        if (this.queueToDrain.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> iterator = this.queueToDrain.iterator();
        while (iterator.hasNext()) {
            BlockPos blockToDrain = iterator.next();
            BlockState blockState = level.getBlockState(blockToDrain);
            Fluid fluid = blockState.getFluidState().getType();
            if (fluid != Fluids.EMPTY) {
                Optional<FluidStack> fs = this.drainBlock(level, blockToDrain, blockState.getBlock(), blockState, fluid, IFluidHandler.FluidAction.SIMULATE);
                if (fs.isPresent()) {
                    FluidStack fluidStack = fs.get();
                    if (pedestal.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) continue;
                    this.drainBlock(level, blockToDrain, blockState.getBlock(), blockState, fluid, IFluidHandler.FluidAction.EXECUTE);
                    pedestal.fillConnectedTank(fluidStack);
                    iterator.remove();
                    return true;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        ++this.unsuccessfulTries;
        if (this.unsuccessfulTries >= 5) {
            this.queueToDrain.clear();
            this.unsuccessfulTries = 0;
        }
        return false;
    }

    private void updateQueueToDrain(Level level, BlockPos pos, int bucketRange) {
        for (int y = pos.getY() + bucketRange; y >= pos.getY() - bucketRange; --y) {
            for (int x = pos.getX() - bucketRange; x <= pos.getX() + bucketRange; ++x) {
                for (int z = pos.getZ() - bucketRange; z <= pos.getZ() + bucketRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = level.getBlockState(currentBlockPos);
                    Fluid fluid = blockState.getFluidState().getType();
                    if (fluid == Fluids.EMPTY || !this.canDrainBlock(level, currentBlockPos, blockState.getBlock(), blockState, fluid)) continue;
                    this.queueToDrain.add(currentBlockPos);
                }
            }
        }
    }

    private boolean canDrainBlock(Level level, BlockPos pos, Block block, BlockState blockState, Fluid fluid) {
        return this.drainBlock(level, pos, block, blockState, fluid, IFluidHandler.FluidAction.SIMULATE).isPresent();
    }

    private Optional<FluidStack> drainBlock(Level level, BlockPos pos, Block block, BlockState blockState, Fluid fluid, IFluidHandler.FluidAction action) {
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            BucketPickupHandlerWrapper targetFluidHandler = new BucketPickupHandlerWrapper(null, bucketPickup, level, pos);
            return Optional.of(targetFluidHandler.drain(new FluidStack(fluid, 1000), action));
        }
        if (block instanceof LiquidBlock) {
            int fluidLevel = (Integer)blockState.getValue((Property)LiquidBlock.LEVEL);
            if (fluidLevel != 0) {
                return Optional.empty();
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
            return Optional.of(new FluidStack(fluid, 1000));
        }
        return Optional.empty();
    }

    private boolean milkCows(Level level, IPedestal pedestal, BlockPos pos, int bucketRange, ItemStack stack) {
        List entities = level.getEntitiesOfClass(Cow.class, new AABB((double)pos.getX() - (double)bucketRange, (double)pos.getY() - (double)bucketRange, (double)pos.getZ() - (double)bucketRange, (double)pos.getX() + (double)bucketRange, (double)pos.getY() + (double)bucketRange, (double)pos.getZ() + (double)bucketRange));
        if (entities.isEmpty()) {
            return false;
        }
        Cow cow = (Cow)entities.get(level.random.nextInt(entities.size()));
        pedestal.getFakePlayer().ifPresent(fakePlayer -> this.milkCow(level, pedestal, pos, stack, cow, (FakePlayer)fakePlayer));
        return true;
    }

    private void milkCow(Level level, IPedestal pedestal, BlockPos pos, ItemStack stack, Cow cow, FakePlayer fakePlayer) {
        int fluidAdded;
        fakePlayer.setPos((double)pos.getX(), 0.0, (double)pos.getZ());
        ItemStack bucketStack = new ItemStack((ItemLike)Items.BUCKET);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, bucketStack);
        cow.mobInteract((Player)fakePlayer, InteractionHand.MAIN_HAND);
        if (fakePlayer.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Items.MILK_BUCKET && (fluidAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000))) == 0) {
            if (stack.getCount() == 1) {
                pedestal.setItem(new ItemStack((ItemLike)Items.MILK_BUCKET));
            } else if (stack.getCount() > 1) {
                stack.shrink(1);
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Items.MILK_BUCKET));
                level.addFreshEntity((Entity)entity);
            }
        }
    }
}

