/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.entity.ReliquaryFakePlayer;
import reliquary.network.PedestalFishHookPayload;
import reliquary.reference.Config;

public class PedestalFishingRodWrapper
implements IPedestalActionItemWrapper {
    private static final int RANGE = 4;
    private static final int NO_WATER_COOLDOWN = 100;
    private static final int BAD_THROW_TIMEOUT = 60;
    private static final int ABSOLUTE_TIMEOUT = 1200;
    private ReliquaryFakePlayer fakePlayer;
    private boolean badThrowChecked;
    private int ticksSinceLastThrow;
    private boolean retractFail = false;

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        ++this.ticksSinceLastThrow;
        if (this.fakePlayer != null && this.fakePlayer.fishing != null) {
            this.handleHookStates(stack, level, pedestal);
            this.syncHookData(this.fakePlayer.serverLevel(), pedestal);
        } else {
            this.setupFakePlayer(level, pedestal.getBlockPosition());
            Optional<BlockPos> p = this.getBestWaterBlock(level, pedestal);
            if (p.isPresent()) {
                this.updateHeldItem(stack);
                this.setPitchYaw(p.get());
                this.spawnFishHook(level, pedestal);
                this.badThrowChecked = false;
                this.ticksSinceLastThrow = 0;
            } else {
                pedestal.setActionCoolDown(100);
            }
        }
    }

    private void handleHookStates(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.retractFail) {
            if (this.fakePlayer != null && this.fakePlayer.fishing != null && this.fakePlayer.fishing.nibble == 0) {
                this.retractHook(pedestal, stack);
                this.retractFail = false;
            }
        } else if (!this.badThrowChecked && this.ticksSinceLastThrow > 60) {
            FishingHook fishingHook = this.fakePlayer.fishing;
            if (fishingHook.currentState != FishingHook.FishHookState.BOBBING) {
                this.retractHook(pedestal, stack);
            } else {
                this.badThrowChecked = true;
            }
        } else if (this.ticksSinceLastThrow > 1200) {
            this.retractHook(pedestal, stack);
        } else if (this.fakePlayer.fishing.nibble > 0 || this.fakePlayer.fishing.getHookedIn() != null) {
            if (level.random.nextInt(100) <= (Integer)Config.COMMON.blocks.pedestal.fishingWrapperSuccessRate.get()) {
                this.retractHook(pedestal, stack);
            } else {
                this.retractFail = true;
            }
        }
    }

    private void updateHeldItem(ItemStack fishingRod) {
        ItemStack heldItem = this.fakePlayer.getMainHandItem();
        if (heldItem.isEmpty()) {
            this.fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, fishingRod);
            return;
        }
        if (heldItem.getItem() != fishingRod.getItem()) {
            this.fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, fishingRod);
        }
    }

    private void retractHook(IPedestal pedestal, ItemStack stack) {
        int i = this.fakePlayer.fishing.retrieve(stack);
        this.fakePlayer.fishing = null;
        stack.hurtAndBreak(i, this.fakePlayer.serverLevel(), (ServerPlayer)this.fakePlayer, item -> {});
        if (stack.getCount() == 0) {
            pedestal.destroyItem();
        }
        pedestal.setActionCoolDown((Integer)Config.COMMON.blocks.pedestal.fishingWrapperRetractDelay.get() * 20);
    }

    private Optional<BlockPos> getBestWaterBlock(Level level, IPedestal pedestal) {
        ArrayList<List<BlockPos>> connectedGroups = new ArrayList<List<BlockPos>>();
        ArrayList<BlockPos> visitedBlocks = new ArrayList<BlockPos>();
        BlockPos pos = pedestal.getBlockPosition();
        int pedestalX = pos.getX();
        int pedestalY = pos.getY();
        int pedestalZ = pos.getZ();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pedestalX, pedestalY, pedestalZ);
        for (int y = pedestalY - 4; y < pedestalY; ++y) {
            checkPos.setY(y);
            for (int r = 1; r <= 4; ++r) {
                int x;
                int z = pedestalZ - r;
                checkPos.setZ(z);
                for (x = pedestalX - r; x <= pedestalX + r; ++x) {
                    checkPos.setX(x);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                }
                --x;
                while (z <= pedestalZ + r) {
                    checkPos.setZ(z);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    ++z;
                }
                --z;
                while (x >= pedestalX - r) {
                    checkPos.setX(x);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    --x;
                }
                while (z >= pedestalZ - r) {
                    checkPos.setZ(z);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    --z;
                }
            }
        }
        return this.getClosestBlock(connectedGroups, pedestalX, pedestalY, pedestalZ);
    }

    private Optional<BlockPos> getClosestBlock(List<List<BlockPos>> connectedGroups, int pedestalX, int pedestalY, int pedestalZ) {
        BlockPos closestBlockInLargestGroup = null;
        int closestSqDistance = Integer.MAX_VALUE;
        int mostBlocks = 0;
        for (List<BlockPos> group : connectedGroups) {
            if (group.size() <= mostBlocks) continue;
            mostBlocks = group.size();
            for (BlockPos waterPos : group) {
                int zDiff;
                int yDiff;
                int xDiff = waterPos.getX() - pedestalX;
                int sqDistance = xDiff * xDiff + (yDiff = waterPos.getY() - pedestalY) * yDiff + (zDiff = waterPos.getZ() - pedestalZ) * zDiff;
                if (sqDistance >= closestSqDistance) continue;
                closestSqDistance = sqDistance;
                closestBlockInLargestGroup = waterPos;
            }
        }
        return Optional.ofNullable(closestBlockInLargestGroup);
    }

    private void checkForAndAddWaterBlocks(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, List<List<BlockPos>> connectedGroups, BlockPos pedestalPos, BlockPos checkPos) {
        if (!visitedBlocks.contains(checkPos)) {
            ArrayList<BlockPos> group = new ArrayList<BlockPos>();
            this.checkForWaterAndSearchNeighbors(level, pedestal, visitedBlocks, pedestalPos, checkPos, group);
            if (!group.isEmpty()) {
                connectedGroups.add(group);
            }
        }
    }

    private void checkForWaterAndSearchNeighbors(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, BlockPos pedestalPos, BlockPos blockPos, List<BlockPos> group) {
        visitedBlocks.add(blockPos.immutable());
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.getBlock() == Blocks.WATER) {
            double startZ;
            double startY;
            int x = blockPos.getX();
            int y = blockPos.getY();
            int z = blockPos.getZ();
            double startX = this.fakePlayer.getX();
            BlockHitResult raytraceresult = level.clip(new ClipContext(new Vec3(startX, startY = this.fakePlayer.getY(), startZ = this.fakePlayer.getZ()), new Vec3((double)x + 0.5, (double)y + 0.8, (double)z + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this.fakePlayer));
            if (raytraceresult.getType() != HitResult.Type.MISS && raytraceresult.getBlockPos().equals((Object)blockPos)) {
                group.add(blockPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = blockPos.relative(direction);
                    if (neighborPos.getX() > pedestalPos.getX() + 4 || neighborPos.getX() < pedestalPos.getX() - 4 || neighborPos.getY() > pedestalPos.getY() + 4 || neighborPos.getY() < pedestalPos.getY() - 4) continue;
                    this.addNeighboringWater(level, pedestal, visitedBlocks, group, pedestalPos, neighborPos);
                }
            }
        }
    }

    private void addNeighboringWater(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, List<BlockPos> group, BlockPos pedestalPos, BlockPos blockPos) {
        if (!visitedBlocks.contains(blockPos)) {
            this.checkForWaterAndSearchNeighbors(level, pedestal, visitedBlocks, pedestalPos, blockPos, group);
        }
    }

    private void spawnFishHook(Level level, IPedestal pedestal) {
        level.playSound(null, pedestal.getBlockPosition(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)new FishingHook((Player)this.fakePlayer, level, 0, 0){

            @Nullable
            public Entity getOwner() {
                return PedestalFishingRodWrapper.this.fakePlayer;
            }

            public boolean broadcastToPlayer(ServerPlayer player) {
                return false;
            }
        });
    }

    private void syncHookData(ServerLevel level, IPedestal pedestal) {
        FishingHook hook = this.fakePlayer.fishing;
        BlockPos pedestalPos = pedestal.getBlockPosition();
        if (hook == null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pedestalPos), (CustomPacketPayload)new PedestalFishHookPayload(pedestal.getBlockPosition(), -1.0, -1.0, -1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pedestalPos), (CustomPacketPayload)new PedestalFishHookPayload(pedestal.getBlockPosition(), hook.getX(), hook.getY(), hook.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.fishing != null) {
            this.fakePlayer.fishing.discard();
        }
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.fishing != null) {
            this.fakePlayer.fishing.discard();
            this.syncHookData(this.fakePlayer.serverLevel(), pedestal);
        }
    }

    private void setupFakePlayer(Level level, BlockPos pos) {
        if (this.fakePlayer == null) {
            this.fakePlayer = new ReliquaryFakePlayer((ServerLevel)level);
            this.fakePlayer.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5);
        }
    }

    private void setPitchYaw(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double degree = 57.29577951308232;
        double dx = this.fakePlayer.getX() - ((double)x + 0.5);
        double dy = this.fakePlayer.getY() - (double)y;
        double dz = this.fakePlayer.getZ() - ((double)z + 0.5);
        this.fakePlayer.setYRot((float)(-(Math.atan2(dx, dz) * degree + 180.0)));
        this.fakePlayer.setXRot((float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * degree));
    }

    @Override
    public Optional<Vec3> getRenderBoundingBoxOuterPosition() {
        return this.fakePlayer != null && this.fakePlayer.fishing != null ? Optional.of(this.fakePlayer.fishing.position()) : Optional.empty();
    }
}

