/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util.potions;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import org.apache.commons.lang3.stream.Streams;
import reliquary.init.ModItems;
import reliquary.reference.Config;
import reliquary.util.LogHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionEssenceComparator;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionIngredient;

public class PotionMap {
    protected static final List<PotionIngredient> ingredients = new ArrayList<PotionIngredient>();
    public static final List<PotionEssence> potionCombinations = new ArrayList<PotionEssence>();
    public static final List<PotionEssence> uniquePotionEssences = new ArrayList<PotionEssence>();
    public static final List<PotionEssence> uniquePotions = new ArrayList<PotionEssence>();

    private PotionMap() {
    }

    public static void initPotionMap() {
        PotionMap.setDefaultInConfigIfEmpty();
        PotionMap.loadPotionMapFromSettings();
        LogHelper.debug("Starting calculation of potion combinations");
        PotionMap.loadPotionCombinations();
        PotionMap.loadUniquePotions();
        LogHelper.debug("Done with potion combinations");
    }

    private static void setDefaultInConfigIfEmpty() {
        if (((List)Config.COMMON.potions.potionMap.get()).isEmpty()) {
            Config.COMMON.potions.potionMap.set(PotionMap.getDefaultConfigPotionMap());
        }
    }

    private static void loadUniquePotions() {
        uniquePotionEssences.clear();
        uniquePotions.clear();
        for (PotionEssence essence : potionCombinations) {
            boolean found = false;
            for (PotionEssence uniqueEssence : uniquePotionEssences) {
                if (!PotionMap.effectsEqual(essence.getPotionContents(), uniqueEssence.getPotionContents())) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniquePotionEssences.add(essence);
            PotionMap.addUniquePotions(essence);
        }
        uniquePotionEssences.sort(new PotionEssenceComparator());
        uniquePotions.sort(new PotionEssenceComparator());
    }

    private static void addUniquePotions(PotionEssence essence) {
        uniquePotions.add(essence);
        if (Boolean.TRUE.equals(Config.COMMON.potions.redstoneAndGlowstone.get())) {
            PotionEssence redstone = essence.copy();
            redstone.setPotionContents(PotionHelper.augmentPotionContents(redstone.getPotionContents(), 1, 0));
            redstone.setRedstoneCount(1);
            uniquePotions.add(redstone);
            PotionEssence glowstone = essence.copy();
            glowstone.setPotionContents(PotionHelper.augmentPotionContents(redstone.getPotionContents(), 0, 1));
            glowstone.setGlowstoneCount(1);
            uniquePotions.add(glowstone);
            PotionEssence redstoneGlowstone = essence.copy();
            redstoneGlowstone.setPotionContents(PotionHelper.augmentPotionContents(redstone.getPotionContents(), 1, 1));
            redstoneGlowstone.setRedstoneCount(1);
            redstoneGlowstone.setGlowstoneCount(1);
            uniquePotions.add(redstoneGlowstone);
        }
    }

    private static void loadPotionCombinations() {
        potionCombinations.clear();
        for (PotionIngredient ingredient1 : ingredients) {
            for (PotionIngredient ingredient2 : ingredients) {
                PotionEssence twoEssence;
                if (ingredient1.getItem().getItem() == ingredient2.getItem().getItem() || !(twoEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2).setPotionContents(PotionHelper.combineIngredients(ingredient1, ingredient2)).build()).getPotionContents().hasEffects() || Iterables.size((Iterable)twoEssence.getPotionContents().getAllEffects()) > (Integer)Config.COMMON.potions.maxEffectCount.get()) continue;
                PotionMap.addPotionCombination(twoEssence);
                if (!Boolean.TRUE.equals(Config.COMMON.potions.threeIngredients.get())) continue;
                for (PotionIngredient ingredient3 : ingredients) {
                    if (ingredient3.getItem().getItem() == ingredient1.getItem().getItem() || ingredient3.getItem().getItem() == ingredient2.getItem().getItem()) continue;
                    PotionEssence threeEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2, ingredient3).setPotionContents(PotionHelper.combineIngredients(ingredient1, ingredient2, ingredient3)).build();
                    if (PotionMap.effectsEqual(twoEssence.getPotionContents(), threeEssence.getPotionContents())) continue;
                    PotionMap.addPotionCombination(threeEssence);
                }
            }
        }
    }

    private static void addPotionCombination(PotionEssence newEssence) {
        for (PotionEssence essence : potionCombinations) {
            if (PotionMap.ingredientsEqual(essence.getIngredients(), newEssence.getIngredients())) {
                return;
            }
            if (!PotionMap.effectsEqual(essence.getPotionContents(), newEssence.getPotionContents(), (Boolean)Config.COMMON.potions.differentDurations.get()) || PotionMap.effectsEqual(essence.getPotionContents(), newEssence.getPotionContents())) continue;
            return;
        }
        potionCombinations.add(newEssence);
    }

    private static boolean ingredientsEqual(List<PotionIngredient> a, List<PotionIngredient> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionIngredient ingredientA : a) {
            boolean found = false;
            for (PotionIngredient ingredientB : b) {
                if (ingredientA.getItem().getItem() != ingredientB.getItem().getItem()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean effectsEqual(PotionContents contents1, PotionContents contents2) {
        return PotionMap.effectsEqual(contents1, contents2, true);
    }

    private static boolean effectsEqual(PotionContents contents1, PotionContents contents2, boolean compareDuration) {
        List effects1 = Streams.of((Iterable)contents1.getAllEffects()).toList();
        List effects2 = Streams.of((Iterable)contents2.getAllEffects()).toList();
        if (effects1.size() != effects2.size()) {
            return false;
        }
        for (MobEffectInstance effectA : effects1) {
            boolean found = false;
            for (MobEffectInstance effectB : effects2) {
                if (!effectA.getDescriptionId().equals(effectB.getDescriptionId()) || compareDuration && effectA.getDuration() != effectB.getDuration() || effectA.getAmplifier() != effectB.getAmplifier()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void loadPotionMapFromSettings() {
        ingredients.clear();
        Pattern validEntry = Pattern.compile("[a-z_:0-9]+=[a-z_0-9:.|;]+");
        for (String entry : (List)Config.COMMON.potions.potionMap.get()) {
            if (validEntry.matcher(entry).matches()) {
                String[] entryParts = entry.split("=");
                String name = entryParts[0];
                String[] effects = entryParts[1].split(";");
                PotionMap.addItemEffectsToPotionMap(name, effects);
                continue;
            }
            LogHelper.error("Potion map entry \"" + entry + "\" is not valid.\nNeeds to be mod:item_or_block_registry_name=potion_effect_name|duration_multiplier|amplifier\nPotion effect part (\"potion_effect_name|...|amplifier\") can be optionally repeated if there are multiple effects on item, the individual potion sections are delimited by semicolon \";\"\nDuration multiplier is multiples of 15 seconds the potion will last");
        }
    }

    private static void addItemEffectsToPotionMap(String name, String[] effects) {
        PotionMap.getItemStackFromName(name).ifPresent(stack -> {
            PotionIngredient ingredient = new PotionIngredient((ItemStack)stack);
            for (String effect : effects) {
                String[] effectValues = effect.split("\\|");
                String potionName = effectValues[0];
                if (potionName.isEmpty()) continue;
                short durationWeight = Short.parseShort(effectValues[1]);
                short ampWeight = Short.parseShort(effectValues[2]);
                ingredient.addEffect(potionName, durationWeight, ampWeight);
            }
            if (!ingredient.getEffects().isEmpty()) {
                ingredients.add(ingredient);
            }
        });
    }

    public static List<String> getDefaultConfigPotionMap() {
        ArrayList<String> potionMap = new ArrayList<String>();
        PotionMap.addPotionIngredient(potionMap, Items.SUGAR, PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.APPLE, PotionMap.heal(0), PotionMap.hboost(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.COAL, PotionMap.blind(1), PotionMap.absorb(3, 0), PotionMap.invis(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.FEATHER, PotionMap.jump(3, 0), PotionMap.weak(1, 0), PotionMap.flight(1));
        PotionMap.addPotionIngredient(potionMap, Items.WHEAT_SEEDS, PotionMap.harm(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.WHEAT, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.FLINT, PotionMap.harm(0), PotionMap.dboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.PORKCHOP, PotionMap.slow(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.LEATHER, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.CLAY_BALL, PotionMap.slow(1, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.EGG, PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.RED_DYE, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.YELLOW_DYE, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.GREEN_DYE, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.BONE_MEAL, PotionMap.weak(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.PUMPKIN_SEEDS, PotionMap.invis(1), PotionMap.fireres(1));
        PotionMap.addPotionIngredient(potionMap, Items.BEEF, PotionMap.slow(1, 0), PotionMap.satur(5));
        PotionMap.addPotionIngredient(potionMap, Items.CHICKEN, PotionMap.nausea(1), PotionMap.poison(1));
        PotionMap.addPotionIngredient(potionMap, Items.ROTTEN_FLESH, PotionMap.nausea(1), PotionMap.hunger(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.GOLD_NUGGET, PotionMap.dboost(0, 0), PotionMap.haste(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.CARROT, PotionMap.vision(3), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.POTATO, PotionMap.hboost(3, 0), PotionMap.satur(2));
        PotionMap.addPotionIngredient(potionMap, Items.COD, PotionMap.satur(3), PotionMap.breath(1));
        PotionMap.addPotionIngredient(potionMap, Items.SPIDER_EYE, PotionMap.vision(4), PotionMap.poison(2));
        PotionMap.addPotionIngredient(potionMap, Items.BLAZE_POWDER, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.flight(1));
        PotionMap.addPotionIngredient(potionMap, Items.IRON_INGOT, PotionMap.resist(4, 0), PotionMap.slow(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.STRING, PotionMap.slow(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.BREAD, PotionMap.hboost(4, 0), PotionMap.satur(5));
        PotionMap.addPotionIngredient(potionMap, Items.COOKED_PORKCHOP, PotionMap.fatigue(2, 0), PotionMap.satur(5));
        PotionMap.addPotionIngredient(potionMap, Items.SLIME_BALL, PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.COOKED_COD, PotionMap.satur(4), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.LAPIS_LAZULI, PotionMap.haste(4, 0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.INK_SAC, PotionMap.blind(2), PotionMap.invis(2));
        PotionMap.addPotionIngredient(potionMap, Items.BONE, PotionMap.weak(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.COOKIE, PotionMap.heal(0), PotionMap.satur(3));
        PotionMap.addPotionIngredient(potionMap, Items.MELON, PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.COOKED_BEEF, PotionMap.resist(4, 0), PotionMap.satur(5));
        PotionMap.addPotionIngredient(potionMap, Items.COOKED_CHICKEN, PotionMap.jump(4, 0), PotionMap.satur(5));
        PotionMap.addPotionIngredient(potionMap, Items.BAKED_POTATO, PotionMap.satur(4), PotionMap.regen(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.POISONOUS_POTATO, PotionMap.poison(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.QUARTZ, PotionMap.harm(0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.ZOMBIE_HEART.get(), PotionMap.nausea(2), PotionMap.hunger(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.SQUID_BEAK.get(), PotionMap.hunger(2), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.PUMPKIN_PIE, PotionMap.invis(1), PotionMap.fireres(1), PotionMap.speed(3, 0), PotionMap.haste(3, 0), PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.MAGMA_CREAM, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.GLISTERING_MELON_SLICE, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.GHAST_TEAR, PotionMap.regen(3, 0), PotionMap.absorb(5, 0), PotionMap.flight(2));
        PotionMap.addPotionIngredient(potionMap, Items.FERMENTED_SPIDER_EYE, PotionMap.vision(4), PotionMap.poison(2), PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.GOLDEN_CARROT, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.hboost(3, 0), PotionMap.vision(3));
        PotionMap.addPotionIngredient(potionMap, Items.GOLD_INGOT, PotionMap.dboost(4, 0), PotionMap.haste(4, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, ModItems.RIB_BONE.get(), PotionMap.weak(3, 0), PotionMap.fatigue(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.ENDER_PEARL, PotionMap.invis(5), PotionMap.speed(5, 0));
        PotionMap.addPotionIngredient(potionMap, Items.BLAZE_ROD, PotionMap.dboost(8, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient(potionMap, Items.FIRE_CHARGE, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.CATALYZING_GLAND.get(), PotionMap.regen(3, 0), PotionMap.hboost(5, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.CHELICERAE.get(), PotionMap.poison(3), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.SLIME_PEARL.get(), PotionMap.resist(5, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.KRAKEN_SHELL_FRAGMENT.get(), PotionMap.absorb(5, 0), PotionMap.breath(5));
        PotionMap.addPotionIngredient(potionMap, ModItems.BAT_WING.get(), PotionMap.jump(5, 0), PotionMap.weak(3, 0), PotionMap.flight(2));
        PotionMap.addPotionIngredient(potionMap, Items.GOLDEN_APPLE, PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.GOLDEN_APPLE, PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, Items.DIAMOND, PotionMap.resist(6, 1), PotionMap.absorb(6, 1), PotionMap.fireres(6), PotionMap.cure(0), PotionMap.flight(1));
        PotionMap.addPotionIngredient(potionMap, ModItems.WITHERED_RIB.get(), PotionMap.wither(2, 1), PotionMap.weak(3, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.ENDER_EYE, PotionMap.dboost(6, 1), PotionMap.invis(6), PotionMap.speed(6, 1), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, Items.EMERALD, PotionMap.haste(6, 1), PotionMap.speed(6, 1), PotionMap.hboost(6, 1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.NETHER_STAR, PotionMap.hboost(24, 1), PotionMap.regen(24, 1), PotionMap.absorb(24, 1), PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, ModItems.MOLTEN_CORE.get(), PotionMap.dboost(6, 1), PotionMap.fireres(6), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, ModItems.EYE_OF_THE_STORM.get(), PotionMap.haste(24, 1), PotionMap.speed(24, 1), PotionMap.jump(24, 1), PotionMap.harm(1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, ModItems.FERTILE_ESSENCE.get(), PotionMap.hboost(8, 1), PotionMap.regen(3, 1), PotionMap.heal(1), PotionMap.satur(4), PotionMap.weak(9, 1), PotionMap.fatigue(9, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, ModItems.FROZEN_CORE.get(), PotionMap.absorb(6, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.harm(1), PotionMap.fireres(6));
        PotionMap.addPotionIngredient(potionMap, ModItems.NEBULOUS_HEART.get(), PotionMap.vision(6), PotionMap.invis(6), PotionMap.harm(1), PotionMap.hboost(6, 1), PotionMap.dboost(6, 1), PotionMap.speed(6, 1), PotionMap.haste(6, 1));
        PotionMap.addPotionIngredient(potionMap, ModItems.INFERNAL_CLAW.get(), PotionMap.harm(1), PotionMap.resist(6, 1), PotionMap.fireres(6), PotionMap.dboost(6, 1), PotionMap.satur(5), PotionMap.heal(1));
        return potionMap;
    }

    private static String harm(int potency) {
        return PotionMap.effectString("instant_damage", Integer.toString(0), Integer.toString(potency));
    }

    private static String heal(int potency) {
        return PotionMap.effectString("instant_health", Integer.toString(0), Integer.toString(potency));
    }

    private static String satur(int potency) {
        return PotionMap.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    private static String invis(int duration) {
        return PotionMap.effectString("invisibility", Integer.toString(duration), Integer.toString(0));
    }

    private static String absorb(int duration, int potency) {
        return PotionMap.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    private static String hboost(int duration, int potency) {
        return PotionMap.effectString("health_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String dboost(int duration, int potency) {
        return PotionMap.effectString("strength", Integer.toString(duration), Integer.toString(potency));
    }

    private static String speed(int duration, int potency) {
        return PotionMap.effectString("speed", Integer.toString(duration), Integer.toString(potency));
    }

    private static String haste(int duration, int potency) {
        return PotionMap.effectString("haste", Integer.toString(duration), Integer.toString(potency));
    }

    private static String slow(int duration, int potency) {
        return PotionMap.effectString("slowness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fatigue(int duration, int potency) {
        return PotionMap.effectString("mining_fatigue", Integer.toString(duration), Integer.toString(potency));
    }

    private static String breath(int duration) {
        return PotionMap.effectString("water_breathing", Integer.toString(duration), Integer.toString(0));
    }

    private static String vision(int duration) {
        return PotionMap.effectString("night_vision", Integer.toString(duration), Integer.toString(0));
    }

    private static String resist(int duration, int potency) {
        return PotionMap.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fireres(int duration) {
        return PotionMap.effectString("fire_resistance", Integer.toString(duration), Integer.toString(0));
    }

    private static String weak(int duration, int potency) {
        return PotionMap.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String jump(int duration, int potency) {
        return PotionMap.effectString("jump_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String flight(int duration) {
        return PotionMap.effectString("reliquary:flight", Integer.toString(duration), Integer.toString(0));
    }

    private static String nausea(int duration) {
        return PotionMap.effectString("nausea", Integer.toString(duration), Integer.toString(0));
    }

    private static String hunger(int duration) {
        return PotionMap.effectString("hunger", Integer.toString(duration), Integer.toString(0));
    }

    private static String regen(int duration, int potency) {
        return PotionMap.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    private static String poison(int duration) {
        return PotionMap.effectString("poison", Integer.toString(duration), Integer.toString(0));
    }

    private static String wither(int duration, int potency) {
        return PotionMap.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    private static String blind(int duration) {
        return PotionMap.effectString("blindness", Integer.toString(duration), Integer.toString(0));
    }

    private static String cure(int potency) {
        return PotionMap.effectString("reliquary:cure", Integer.toString(1), Integer.toString(potency));
    }

    private static String effectString(String name, String duration, String potency) {
        return name + "|" + duration + "|" + potency;
    }

    private static void addPotionIngredient(List<String> potionMap, Item ingredient, String ... effects) {
        PotionMap.addPotionIngredient(potionMap, RegistryHelper.getRegistryName(ingredient).toString(), effects);
    }

    private static void addPotionIngredient(List<String> potionMap, String itemRegistryName, String ... effects) {
        StringJoiner effectsString = new StringJoiner(";");
        Arrays.stream(effects).forEach(effectsString::add);
        potionMap.add(String.format("%s=%s", itemRegistryName, effectsString));
    }

    public static Optional<ItemStack> getItemStackFromName(String name) {
        return BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)name)).map(ItemStack::new);
    }
}

