/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.network.packet;

import forge.com.cursee.disenchanting_table.client.network.packet.ForgeItemSyncClientHandler;
import forge.com.cursee.disenchanting_table.core.network.ForgeNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;

public class ForgeItemSyncS2CPacket
implements CustomPacketPayload {
    public final BlockPos blockPosition;
    public final int size;
    public final NonNullList<ItemStack> inventory;

    public ForgeItemSyncS2CPacket(BlockPos blockPos, int size, NonNullList<ItemStack> inventory) {
        this.blockPosition = blockPos;
        this.size = size;
        this.inventory = inventory;
    }

    public ForgeItemSyncS2CPacket(RegistryFriendlyByteBuf data) {
        this.blockPosition = data.readBlockPos();
        this.size = data.readInt();
        this.inventory = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.size; ++i) {
            this.inventory.set(i, (Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(data.readResourceLocation())));
        }
    }

    public static void createAndSend(ServerPlayer serverPlayer, NonNullList<ItemStack> inventory, BlockPos blockPos) {
        ForgeNetwork.sendToPlayer(serverPlayer, new ForgeItemSyncS2CPacket(blockPos, inventory.size(), inventory));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ForgeNetwork.ITEM_SYNC_ID;
    }

    public void toBytes(RegistryFriendlyByteBuf data) {
        data.writeBlockPos(this.blockPosition);
        data.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            data.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)((ItemStack)this.inventory.get(i)).getItem()));
        }
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ForgeItemSyncClientHandler.handle(this, context)));
        context.setPacketHandled(true);
    }
}

