/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import com.mojang.serialization.MapCodec;
import earth.terrarium.handcrafted.common.blocks.base.SittableBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.DirectionalBlockProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DiningBenchBlock
extends HorizontalDirectionalBlock
implements SittableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<DiningBenchBlock> CODEC = DiningBenchBlock.simpleCodec(DiningBenchBlock::new);
    public static final EnumProperty<DirectionalBlockProperty> SHAPE = EnumProperty.create((String)"shape", DirectionalBlockProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape X_AXIS_SHAPE = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0);
    public static final VoxelShape Z_AXIS_SHAPE = Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0, (double)13.0);
    public static final AABB SEAT = new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public DiningBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)DirectionalBlockProperty.SINGLE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, FACING, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.sitOn(level, pos, player, null)) {
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.CONSUME_PARTIAL;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    @Override
    public AABB getSeatSize(BlockState state) {
        return SEAT;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)state.getValue((Property)FACING), (BlockGetter)level, currentPos))) : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)state.getValue((Property)FACING), (BlockGetter)context.getLevel(), pos)));
    }

    public static DirectionalBlockProperty getShape(Block block, Direction direction, BlockGetter level, BlockPos pos) {
        boolean check2;
        BlockState state1 = level.getBlockState(pos.relative(direction.getClockWise().getOpposite()));
        BlockState state2 = level.getBlockState(pos.relative(direction.getClockWise()));
        boolean check1 = state1.is(block) && state1.getValue((Property)FACING) != direction;
        boolean bl = check2 = state2.is(block) && state2.getValue((Property)FACING) != direction;
        if (!state1.is(block) && !state2.is(block)) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check1 && state2.is(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (check2 && state1.is(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        if (check1) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check2) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (!state1.is(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (!state2.is(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        return DirectionalBlockProperty.MIDDLE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

