/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.PedestalRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.particle.timelines.PrestidigitationTimeline;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.common.crafting.recipes.PrestidigitationRecipe;
import com.hollingsworth.arsnouveau.common.items.data.PrestidigitationData;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPrestidigitation;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class PrestidigitationWriteEntry
extends PedestalRecipeEntry {
    RecipeHolder<PrestidigitationRecipe> prestidigitationRecipe;

    public PrestidigitationWriteEntry(RecipeHolder<PrestidigitationRecipe> spellWriteRecipe, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.title = Component.translatable((String)"block.ars_nouveau.enchanting_apparatus");
        this.prestidigitationRecipe = spellWriteRecipe;
        ArrayList<Ingredient> ingredients1 = new ArrayList<Ingredient>();
        if (spellWriteRecipe != null) {
            for (Ingredient ingredient : ((PrestidigitationRecipe)spellWriteRecipe.value()).pedestalItems()) {
                if (ingredient.test(new ItemStack(ItemsRegistry.SPELL_PARCHMENT))) {
                    ItemStack replacementParchment = new ItemStack(ItemsRegistry.SPELL_PARCHMENT);
                    replacementParchment.set(DataComponentRegistry.SPELL_CASTER, (Object)((SpellCaster)new SpellCaster(0, "", false, "", 1).setSpell(new Spell().add((AbstractSpellPart)EffectPrestidigitation.INSTANCE))));
                    ingredients1.add(Ingredient.of((ItemStack[])new ItemStack[]{replacementParchment}));
                    continue;
                }
                ingredients1.add(ingredient);
            }
            this.ingredients = ingredients1;
        }
        this.reagentStack = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.STICK)});
        ItemStack outputStick = new ItemStack((ItemLike)Items.STICK);
        outputStick.set(DataComponentRegistry.PRESTIDIGITATION, (Object)new PrestidigitationData(new PrestidigitationTimeline()));
        this.outputStack = outputStick;
    }

    public static SinglePageCtor create(ResourceLocation id) {
        return (parent, x, y, width, height) -> {
            RecipeHolder recipe = parent.recipeManager().byKeyTyped((RecipeType)RecipeRegistry.PRESTIDIGITATION_TYPE.get(), id);
            return new PrestidigitationWriteEntry((RecipeHolder<PrestidigitationRecipe>)recipe, parent, x, y, width, height);
        };
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.prestidigitationRecipe != null) {
            object.addProperty(DocExporter.RECIPE_PROPERTY, this.prestidigitationRecipe.id().toString());
        }
    }
}

