/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.BurstMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.UpwardsFieldMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.MotionProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.BaseTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class LingerTimeline
extends BaseTimeline<LingerTimeline> {
    public static final MapCodec<LingerTimeline> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimelineEntryData.CODEC.fieldOf("trailEffect").forGetter(i -> i.trailEffect), (App)TimelineEntryData.CODEC.fieldOf("onResolvingEffect").forGetter(i -> i.onResolvingEffect), (App)SoundProperty.CODEC.fieldOf("resolveSound").forGetter(i -> i.resolveSound)).apply((Applicative)instance, LingerTimeline::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LingerTimeline> STREAM_CODEC = StreamCodec.composite(TimelineEntryData.STREAM, LingerTimeline::trailEffect, TimelineEntryData.STREAM, LingerTimeline::onResolvingEffect, SoundProperty.STREAM_CODEC, i -> i.resolveSound, LingerTimeline::new);
    public static final List<IParticleMotionType<?>> TRAIL_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> RESOLVING_OPTIONS = new CopyOnWriteArrayList();
    public TimelineEntryData trailEffect;
    public TimelineEntryData onResolvingEffect;
    public SoundProperty resolveSound = new SoundProperty();

    public LingerTimeline() {
        this(new TimelineEntryData((ParticleMotion)new UpwardsFieldMotion(), new PropertyParticleOptions()), new TimelineEntryData((ParticleMotion)new BurstMotion(), new PropertyParticleOptions()), new SoundProperty());
    }

    public LingerTimeline(TimelineEntryData trailEffect, TimelineEntryData onResolvingEffect, SoundProperty resolveSound) {
        this.trailEffect = trailEffect;
        this.onResolvingEffect = onResolvingEffect;
        this.resolveSound = resolveSound;
    }

    public TimelineEntryData trailEffect() {
        return this.trailEffect;
    }

    public TimelineEntryData onResolvingEffect() {
        return this.onResolvingEffect;
    }

    @Override
    public IParticleTimelineType<LingerTimeline> getType() {
        return (IParticleTimelineType)ParticleTimelineRegistry.LINGER_TIMELINE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties() {
        return List.of(new MotionProperty(new TimelineOption(TimelineOption.TICK, this.trailEffect, ImmutableList.copyOf(TRAIL_OPTIONS))), new MotionProperty(new TimelineOption(TimelineOption.IMPACT, this.onResolvingEffect, ImmutableList.copyOf(RESOLVING_OPTIONS)), List.of(this.resolveSound)));
    }
}

