/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record TimelineMap(Map<IParticleTimelineType<?>, IParticleTimeline<?>> timelines) {
    public static Codec<TimelineMap> CODEC = Codec.unboundedMap(IParticleTimelineType.CODEC, IParticleTimeline.CODEC).xmap(TimelineMap::new, timelineMap -> timelineMap.timelines);
    public static final StreamCodec<RegistryFriendlyByteBuf, TimelineMap> STREAM = StreamCodec.ofMember((val, buf) -> {
        Set<Map.Entry<IParticleTimelineType<?>, IParticleTimeline<?>>> entries = val.timelines.entrySet();
        buf.writeInt(entries.size());
        for (Map.Entry<IParticleTimelineType<?>, IParticleTimeline<?>> entry : entries) {
            IParticleTimelineType.STREAM_CODEC.encode(buf, entry.getKey());
            TimelineMap.encodeTimeline(buf, entry.getKey(), entry.getValue());
        }
    }, buf -> {
        int size = buf.readInt();
        ImmutableMap.Builder immutableMap = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            IParticleTimelineType type = (IParticleTimelineType)IParticleTimelineType.STREAM_CODEC.decode(buf);
            IParticleTimeline value = (IParticleTimeline)type.streamCodec().decode(buf);
            immutableMap.put((Object)type, (Object)value);
        }
        return new TimelineMap((Map<IParticleTimelineType<?>, IParticleTimeline<?>>)immutableMap.build());
    });

    public TimelineMap() {
        this((Map<IParticleTimelineType<?>, IParticleTimeline<?>>)ImmutableMap.of());
    }

    @NotNull
    public <T extends IParticleTimeline<T>> T get(IParticleTimelineType<T> type) {
        return (T)(this.timelines.containsKey(type) ? this.timelines.get(type) : type.create());
    }

    @NotNull
    public <T extends IParticleTimeline<T>> T get(Supplier<IParticleTimelineType<T>> type) {
        return this.get(type.get());
    }

    public <T extends IParticleTimeline<T>> TimelineMap put(IParticleTimelineType<T> type, T value) {
        return new TimelineMap(Util.copyAndPut(this.timelines, type, value));
    }

    private static <T extends IParticleTimeline<T>> void encodeTimeline(RegistryFriendlyByteBuf buffer, IParticleTimelineType<T> component, Object value) {
        component.streamCodec().encode((Object)buffer, (Object)((IParticleTimeline)value));
    }

    public MutableTimelineMap mutable() {
        Object copyMap = CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, (Object)this).getOrThrow();
        TimelineMap copyTimeline = (TimelineMap)((Pair)CODEC.decode((DynamicOps)JavaOps.INSTANCE, copyMap).getOrThrow()).getFirst();
        return new MutableTimelineMap(copyTimeline.timelines);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineMap that = (TimelineMap)o;
        return Objects.equals(this.timelines, that.timelines);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.timelines);
    }

    public void debugPrintHash(Spell spell, Level level) {
        System.out.println(level);
        TimelineMap timelineMap = spell.particleTimeline();
        for (IParticleTimelineType<?> data : timelineMap.timelines().keySet()) {
            System.out.println(timelineMap.get(data).hashCode() + " : " + String.valueOf(data));
        }
    }

    public static class MutableTimelineMap {
        private final Map<IParticleTimelineType<?>, IParticleTimeline<? extends IParticleTimeline<?>>> timelines = new HashMap();

        public MutableTimelineMap(Map<IParticleTimelineType<?>, IParticleTimeline<? extends IParticleTimeline<?>>> map) {
            for (Map.Entry<IParticleTimelineType<?>, IParticleTimeline<IParticleTimeline<?>>> entry : map.entrySet()) {
                this.timelines.put(entry.getKey(), entry.getValue());
            }
        }

        public <T extends IParticleTimeline<T>> T getOrCreate(IParticleTimelineType<T> type) {
            return (T)this.timelines.computeIfAbsent(type, key -> type.create());
        }

        public <T extends IParticleTimeline<T>> IParticleTimeline put(IParticleTimelineType<T> type, T value) {
            return this.timelines.put(type, value);
        }

        public TimelineMap immutable() {
            TimelineMap createdMap = new TimelineMap(this.timelines);
            Object copyMap = CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, (Object)createdMap).getOrThrow();
            TimelineMap copyTimeline = (TimelineMap)((Pair)CODEC.decode((DynamicOps)JavaOps.INSTANCE, copyMap).getOrThrow()).getFirst();
            return copyTimeline;
        }
    }
}

