/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.hollingsworth.arsnouveau.api.recipe.PotionCraftingManager;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CraftingManager {
    public ItemStack outputStack;
    public List<ItemStack> neededItems;
    public List<ItemStack> remainingItems;
    public boolean craftCompleted;

    public CraftingManager() {
        this.outputStack = ItemStack.EMPTY;
        this.neededItems = new ArrayList<ItemStack>();
        this.remainingItems = new ArrayList<ItemStack>();
    }

    public CraftingManager(ItemStack outputStack, List<ItemStack> neededItems) {
        this.remainingItems = this.getContainerItems(neededItems);
        this.outputStack = outputStack;
        this.neededItems = neededItems;
    }

    List<ItemStack> getContainerItems(List<ItemStack> items) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (!item.hasCraftingRemainingItem()) continue;
            remaining.add(item.getCraftingRemainingItem());
        }
        return remaining;
    }

    public ItemStack getNextItem() {
        return !this.neededItems.isEmpty() ? this.neededItems.get(0) : ItemStack.EMPTY;
    }

    public boolean giveItem(Item i) {
        if (this.canBeCompleted()) {
            return false;
        }
        ItemStack stackToRemove = ItemStack.EMPTY;
        for (ItemStack stack : this.neededItems) {
            if (stack.getItem() != i) continue;
            stackToRemove = stack;
            break;
        }
        return this.neededItems.remove(stackToRemove);
    }

    public boolean canBeCompleted() {
        return !this.isCraftInvalid() && this.neededItems.isEmpty();
    }

    public boolean isCraftCompleted() {
        return this.isCraftInvalid() || this.craftCompleted;
    }

    public boolean isCraftInvalid() {
        return this.outputStack.isEmpty();
    }

    public void completeCraft(WixieCauldronTile tile) {
        Level level = tile.getLevel();
        BlockPos worldPosition = tile.getBlockPos();
        if (!this.outputStack.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)worldPosition.getX(), (double)worldPosition.getY() + 1.0, (double)worldPosition.getZ(), this.outputStack.copy()));
        }
        for (ItemStack i : this.remainingItems) {
            if (i.isEmpty()) continue;
            level.addFreshEntity((Entity)new ItemEntity(level, (double)worldPosition.getX(), (double)worldPosition.getY() + 1.0, (double)worldPosition.getZ(), i.copy()));
        }
        tile.hasSource = false;
        tile.onCraftingComplete();
        this.craftCompleted = true;
    }

    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        Tag stack = this.outputStack.saveOptional(provider);
        tag.put("output_stack", stack);
        NBTUtil.writeItems(provider, tag, "progress", this.neededItems);
        NBTUtil.writeItems(provider, tag, "refund", this.remainingItems);
        tag.putBoolean("completed", this.craftCompleted);
    }

    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.outputStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("output_stack"));
        this.neededItems = NBTUtil.readItems(provider, tag, "progress");
        this.remainingItems = NBTUtil.readItems(provider, tag, "refund");
    }

    public static CraftingManager fromTag(HolderLookup.Provider provider, CompoundTag tag) {
        CraftingManager craftingManager = tag.getBoolean("isPotion") ? new PotionCraftingManager() : new CraftingManager();
        craftingManager.read(provider, tag);
        return craftingManager;
    }
}

