/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.util.SpellPartConfigUtil;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSpellPart
implements Comparable<AbstractSpellPart> {
    public static final Codec<AbstractSpellPart> CODEC = ResourceLocation.CODEC.xmap(GlyphRegistry::getSpellPartOrDefault, AbstractSpellPart::getRegistryName);
    public static final StreamCodec<RegistryFriendlyByteBuf, AbstractSpellPart> STREAM = StreamCodec.of((buf, val) -> buf.writeResourceLocation(val.getRegistryName()), buf -> GlyphRegistry.getSpellPartOrDefault(buf.readResourceLocation()));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<AbstractSpellPart>> STREAM_LIST = StreamCodec.of((buf, val) -> {
        buf.writeInt(val.size());
        for (AbstractSpellPart part : val) {
            STREAM.encode(buf, (Object)part);
        }
    }, buf -> {
        int size = buf.readInt();
        CopyOnWriteArrayList<AbstractSpellPart> parts = new CopyOnWriteArrayList<AbstractSpellPart>();
        for (int i = 0; i < size; ++i) {
            parts.add((AbstractSpellPart)STREAM.decode(buf));
        }
        return parts;
    });
    private final ResourceLocation registryName;
    public String name;
    public Glyph glyphItem;
    public List<SpellSchool> spellSchools = new CopyOnWriteArrayList<SpellSchool>();
    public Set<AbstractAugment> compatibleAugments = ConcurrentHashMap.newKeySet();
    public Map<AbstractAugment, Component> augmentDescriptions = new ConcurrentHashMap<AbstractAugment, Component>();
    public SpellPartConfigUtil.ComboLimits invalidCombinations = new SpellPartConfigUtil.ComboLimits(null);
    @Nullable
    public ModConfigSpec CONFIG;
    @Nullable
    public ModConfigSpec.IntValue COST;
    @Nullable
    public ModConfigSpec.BooleanValue ENABLED;
    @Nullable
    public ModConfigSpec.BooleanValue STARTER_SPELL;
    @Nullable
    public ModConfigSpec.IntValue PER_SPELL_LIMIT;
    @Nullable
    public ModConfigSpec.IntValue GLYPH_TIER;
    public SpellPartConfigUtil.AugmentLimits augmentLimits;
    public SpellPartConfigUtil.AugmentCosts augmentCosts;

    public abstract Integer getTypeIndex();

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public AbstractSpellPart(String registryName, String name) {
        this(ArsNouveau.prefix(registryName), name);
    }

    public AbstractSpellPart(ResourceLocation registryName, String name) {
        this.registryName = registryName;
        this.name = name;
        for (SpellSchool spellSchool : this.getSchools()) {
            spellSchool.addSpellPart(this);
            this.spellSchools.add(spellSchool);
        }
        this.compatibleAugments.addAll(this.getCompatibleAugments());
        ConcurrentHashMap<AbstractAugment, String> map = new ConcurrentHashMap<AbstractAugment, String>();
        this.addAugmentDescriptions(map);
        for (AbstractAugment augment : map.keySet()) {
            this.augmentDescriptions.put(augment, (Component)Component.translatable((String)("ars_nouveau.augment_desc." + registryName.getPath() + "_" + augment.getRegistryName().getPath())));
        }
        if (!FMLEnvironment.production) {
            for (AbstractAugment augment : this.compatibleAugments) {
                if (this.augmentDescriptions.containsKey(augment)) continue;
                ArsNouveau.postLoadWarnings.add("Glyph " + String.valueOf(registryName) + " is missing a description for augment " + String.valueOf(augment.getRegistryName()));
            }
        }
    }

    public void onContextCanceled(SpellContext context) {
    }

    public boolean contextCanceled(SpellContext context) {
        this.onContextCanceled(context);
        return true;
    }

    protected abstract int getDefaultManaCost();

    public int getCastingCost() {
        return this.COST == null ? this.getDefaultManaCost() : ((Integer)this.COST.get()).intValue();
    }

    public String getName() {
        return this.name;
    }

    public SpellTier getConfigTier() {
        return this.GLYPH_TIER == null ? this.defaultTier() : SpellTier.SPELL_TIER_MAP.get(this.GLYPH_TIER.get());
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this);
        }
        return this.glyphItem;
    }

    @NotNull
    protected abstract Set<AbstractAugment> getCompatibleAugments();

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
    }

    public Component getAugmentLangKey(AbstractAugment augment) {
        return Component.translatable((String)("ars_nouveau.augment_desc." + this.registryName.getPath() + "_" + augment.getRegistryName().getPath()));
    }

    protected Set<AbstractAugment> augmentSetOf(AbstractAugment ... augments) {
        return this.setOf(augments);
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[0]);
    }

    @SafeVarargs
    protected final <T> Set<T> setOf(T ... list) {
        return Set.of(list);
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getConfigTier().value - o.getConfigTier().value;
    }

    public Component getBookDescLang() {
        return Component.translatable((String)(this.getRegistryName().getNamespace() + ".glyph_desc." + this.getRegistryName().getPath()));
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        builder.comment("General settings").push("general");
        this.ENABLED = builder.comment("Is Enabled?").define("enabled", true);
        this.COST = builder.comment("Cost").defineInRange("cost", this.getDefaultManaCost(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.STARTER_SPELL = builder.comment("Is Starter Glyph?").define("starter", this.defaultedStarterGlyph());
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.GLYPH_TIER = builder.comment("The tier of the glyph").defineInRange("glyph_tier", this.defaultTier().value, 1, 99);
    }

    public boolean shouldShowInUnlock() {
        return this.isEnabled();
    }

    public boolean shouldShowInSpellBook() {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return this.ENABLED != null && (Boolean)this.ENABLED.get() != false;
    }

    public int getAugmentLimit(ResourceLocation augmentTag) {
        if (this.augmentLimits == null) {
            return Integer.MAX_VALUE;
        }
        return this.augmentLimits.getAugmentLimit(augmentTag);
    }

    protected void buildAugmentLimitsConfig(ModConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        this.augmentLimits = SpellPartConfigUtil.buildAugmentLimitsConfig(builder, defaults);
    }

    protected void buildAugmentCostOverrideConfig(ModConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        this.augmentCosts = SpellPartConfigUtil.buildAugmentCosts(builder, defaults);
    }

    protected void buildInvalidCombosConfig(ModConfigSpec.Builder builder, Set<ResourceLocation> defaults) {
        this.invalidCombinations = SpellPartConfigUtil.buildInvalidCombosConfig(builder, defaults);
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        this.addDefaultAugmentLimits(defaults);
        return defaults;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
    }

    protected Set<ResourceLocation> getDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        this.addDefaultInvalidCombos(defaults);
        return defaults;
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
    }

    public boolean defaultedStarterGlyph() {
        return false;
    }

    public String getBookDescription() {
        return "";
    }

    public String getLocalizationKey() {
        return this.registryName.getNamespace() + ".glyph_name." + this.registryName.getPath();
    }

    public String getLocaleName() {
        return Component.translatable((String)this.getLocalizationKey()).getString();
    }

    public DocAssets.BlitInfo getTypeIcon() {
        return DocAssets.NA_ICON;
    }

    public abstract Component getTypeName();

    public ParticleEmitter createStaticEmitter(TimelineEntryData timelineEntryData, Vec3 position) {
        return new ParticleEmitter(() -> position, () -> new Vec2(0.0f, 0.0f), timelineEntryData.motion(), timelineEntryData.particleOptions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSpellPart that = (AbstractSpellPart)o;
        return Objects.equals(this.registryName, that.registryName);
    }

    public int hashCode() {
        return Objects.hashCode(this.registryName);
    }
}

