/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.hollingsworth.arsnouveau.client.container.SlotStorage;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.ServerToClientStoragePacket;
import com.hollingsworth.arsnouveau.common.network.SetTerminalSettingsPacket;
import com.hollingsworth.arsnouveau.common.network.UpdateStorageItemsPacket;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class StorageTerminalMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    protected StorageLecternTile te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = new ArrayList<StoredItemStack>();
    protected Inventory pinv;
    public String search;
    public Map<StoredItemStack, StoredItemStack> itemMap = new HashMap<StoredItemStack, StoredItemStack>();
    boolean sentSettings = false;
    public Map<UUID, String> tabs = new HashMap<UUID, String>();
    private Object2LongMap<StoredItemStack> itemLongMap = new Object2LongOpenHashMap();

    public StorageTerminalMenu(int id, Inventory inv, StorageLecternTile te) {
        this((MenuType)MenuRegistry.STORAGE.get(), id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv, StorageLecternTile te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots(false);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv) {
        this(type, id, inv, null);
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.slots.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public void addStorageSlots(boolean expanded) {
        int lines = 7;
        boolean shouldAdd = this.storageSlotList.isEmpty();
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                if (shouldAdd) {
                    this.storageSlotList.add(new SlotStorage(this.te, index, 13 + j * 18, 21 + i * 18, expanded || i < 3));
                    continue;
                }
                this.storageSlotList.get((int)index).show = expanded || i < 3;
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.te != null && this.te.canInteractWith(playerIn);
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get(id).setStack(stack);
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void broadcastChanges() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks(this.tabs.get(this.pinv.player.getUUID()));
        ArrayList<StoredItemStack> toWrite = new ArrayList<StoredItemStack>();
        HashSet found = new HashSet();
        itemsCount.forEach((s, c) -> {
            long pc = this.itemLongMap.getLong(s);
            if (pc != 0L) {
                found.add(s);
            }
            if (pc != c) {
                toWrite.add(new StoredItemStack(s.getStack(), (long)c));
            }
        });
        this.itemLongMap.forEach((s, c) -> {
            if (!found.contains(s)) {
                toWrite.add(new StoredItemStack(s.getStack(), 0L));
            }
        });
        this.itemLongMap.clear();
        this.itemLongMap.putAll(itemsCount);
        if (!toWrite.isEmpty()) {
            Networking.sendToPlayerClient(new UpdateStorageItemsPacket(toWrite), (ServerPlayer)this.pinv.player);
        }
        if (!this.sentSettings) {
            Networking.sendToPlayerClient(new SetTerminalSettingsPacket(this.te.sortSettings, null), (ServerPlayer)this.pinv.player);
            Networking.sendToPlayerClient(new ServerToClientStoragePacket(this.te.getLastSearch(this.pinv.player), this.te.getTabNames()), (ServerPlayer)this.pinv.player);
            this.sentSettings = true;
        }
        super.broadcastChanges();
    }

    public final ItemStack quickMoveStack(Player playerIn, int index) {
        if (this.slots.size() <= index) {
            return ItemStack.EMPTY;
        }
        if (index > this.playerSlotsStart && this.te != null) {
            if (this.slots.get(index) != null && ((Slot)this.slots.get(index)).hasItem()) {
                Slot slot = (Slot)this.slots.get(index);
                ItemStack slotStack = slot.getItem();
                StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.getCount()), this.tabs.get(playerIn.getUUID()));
                ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.EMPTY;
                slot.set(itemstack);
                if (!playerIn.level.isClientSide) {
                    this.broadcastChanges();
                }
            }
        } else if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            return this.shiftClickItems(serverPlayer, index);
        }
        return ItemStack.EMPTY;
    }

    protected ItemStack shiftClickItems(ServerPlayer playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelperIn) {
    }

    public void clearCraftingContent() {
    }

    public boolean recipeMatches(RecipeHolder pRecipe) {
        return false;
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return 0;
    }

    public int getGridHeight() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public void updateItems(List<StoredItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        stacks.forEach(s -> {
            if (s.getQuantity() == 0L) {
                this.itemMap.remove(s);
            } else {
                this.itemMap.put((StoredItemStack)s, (StoredItemStack)s);
            }
        });
        this.itemList = new ArrayList<StoredItemStack>(this.itemMap.values());
        this.pinv.setChanged();
    }

    public final void receiveServerSearchString(String searchString) {
        if (!searchString.isEmpty()) {
            this.search = searchString;
        }
    }

    public void receiveClientSearch(ServerPlayer sender, String search) {
        this.te.setLastSearch((Player)sender, search);
    }

    public void receiveSettings(ServerPlayer sender, SortSettings settings, String selectedTab) {
        this.tabs.put(sender.getUUID(), selectedTab);
        this.te.setSorting(settings);
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int p_150635_) {
        return false;
    }

    public void onInteract(ServerPlayer player, @Nullable StoredItemStack clicked, SlotAction act, boolean pullOne) {
        player.resetLastActionTime();
        if (act == SlotAction.SPACE_CLICK) {
            for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                this.quickMoveStack((Player)player, i);
            }
        } else {
            String selectedTab = this.tabs.get(player.getUUID());
            if (act == SlotAction.PULL_OR_PUSH_STACK) {
                ItemStack stack = this.getCarried();
                if (!stack.isEmpty()) {
                    StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack), selectedTab);
                    ItemStack itemstack = rem == null ? ItemStack.EMPTY : rem.getActualStack();
                    this.setCarried(itemstack);
                } else {
                    if (clicked == null) {
                        return;
                    }
                    StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), selectedTab);
                    if (pulled != null) {
                        this.setCarried(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.PULL_ONE) {
                ItemStack stack = this.getCarried();
                if (clicked == null) {
                    return;
                }
                if (pullOne) {
                    StoredItemStack pulled = this.te.pullStack(clicked, 1, selectedTab);
                    if (pulled != null) {
                        ItemStack itemstack = pulled.getActualStack();
                        this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                        if (itemstack.getCount() > 0) {
                            this.te.pushOrDrop(itemstack, selectedTab);
                        }
                        player.getInventory().setChanged();
                    }
                } else if (!stack.isEmpty()) {
                    StoredItemStack pulled;
                    if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)clicked.getStack()) && stack.getCount() + 1 <= stack.getMaxStackSize() && (pulled = this.te.pullStack(clicked, 1, selectedTab)) != null) {
                        stack.grow(1);
                    }
                } else {
                    StoredItemStack pulled = this.te.pullStack(clicked, 1, selectedTab);
                    if (pulled != null) {
                        this.setCarried(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_HALF) {
                ItemStack stack = this.getCarried();
                if (!stack.isEmpty()) {
                    ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 2, 1));
                    ItemStack itemstack = this.te.pushStack(stack1, selectedTab);
                    stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                    this.setCarried(stack);
                } else {
                    if (clicked == null) {
                        return;
                    }
                    StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(clicked.getQuantity() / 2L, (long)(clicked.getMaxStackSize() / 2)), 1L), selectedTab);
                    if (pulled != null) {
                        this.setCarried(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_QUARTER) {
                ItemStack stack = this.getCarried();
                if (!stack.isEmpty()) {
                    ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 4, 1));
                    ItemStack itemstack = this.te.pushStack(stack1, selectedTab);
                    stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                    this.setCarried(stack);
                } else {
                    if (clicked == null) {
                        return;
                    }
                    long maxCount = 64L;
                    for (StoredItemStack e : this.itemList) {
                        if (!e.equals(clicked)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(maxCount, (long)clicked.getMaxStackSize()) / 4L, 1L), selectedTab);
                    if (pulled != null) {
                        this.setCarried(pulled.getActualStack());
                    }
                }
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), selectedTab);
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                    if (itemstack.getCount() > 0) {
                        this.te.pushOrDrop(itemstack, selectedTab);
                    }
                    player.getInventory().setChanged();
                }
            }
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

    }
}

