/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.common.crafting.recipes.DyeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EmiDyeRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final DyeRecipe recipe;

    public EmiDyeRecipe(ResourceLocation id, DyeRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.CRAFTING;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.recipe.getIngredients().stream().map(EmiIngredient::of).toList();
    }

    public List<EmiStack> getOutputs() {
        ItemStack resultItem = this.recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        ArrayList<EmiStack> results = new ArrayList<EmiStack>();
        Item item = resultItem.getItem();
        if (item instanceof IDyeable) {
            IDyeable toDye = (IDyeable)item;
            List<DyeColor> colors = Arrays.stream(((Ingredient)this.recipe.getIngredients().get(0)).getItems()).map(DyeColor::getColor).toList();
            for (DyeColor color : colors) {
                if (color == null) continue;
                ItemStack copy = resultItem.copy();
                toDye.onDye(copy, color);
                results.add(EmiStack.of((ItemStack)copy));
            }
        }
        return results;
    }

    public int getDisplayWidth() {
        return 118;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
        widgets.addTexture(EmiTexture.SHAPELESS, 97, 0);
        List<EmiIngredient> input = this.getInputs();
        for (int i = 0; i < 9; ++i) {
            if (i < input.size()) {
                widgets.addSlot(input.get(i), i % 3 * 18, i / 3 * 18);
                continue;
            }
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)ItemStack.EMPTY), i % 3 * 18, i / 3 * 18);
        }
        widgets.addSlot(EmiIngredient.of(this.getOutputs()), 92, 14).large(true).recipeContext((EmiRecipe)this);
    }
}

