/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.client.gui.HSLColor;
import com.hollingsworth.arsnouveau.client.gui.HorizontalSlider;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SatLumSlider
extends HorizontalSlider {
    Supplier<HSLColor> baseColor;
    boolean isLuminance = false;

    public SatLumSlider(int x, int y, boolean drawString, boolean isLuminance, Supplier<HSLColor> baseColor, Consumer<Double> onValueChange) {
        super(x, y, DocAssets.SLIDER_BAR, DocAssets.SLIDER, (Component)(isLuminance ? Component.literal((String)"Lightness") : Component.literal((String)"Saturation")), (Component)Component.empty(), 0.0, 1.0, 0.5, 0.01, 1, drawString, onValueChange);
        this.isLuminance = isLuminance;
        this.baseColor = baseColor;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        DocClientUtils.blit(guiGraphics, this.sliderAsset, this.x, this.y);
        int drawWidth = this.width - 6;
        int drawX = this.x + 3;
        HSLColor baseColor = this.baseColor.get();
        HSLColor leftColor = HSLColor.hsl(baseColor.getHue(), this.isLuminance ? baseColor.getSaturation() : 0.01, this.isLuminance ? 0.01 : baseColor.getLightness(), baseColor.getOpacity());
        guiGraphics.vLine(drawX - 1, this.y + 2, this.y + 4, leftColor.toInt());
        HSLColor rightColor = HSLColor.hsl(baseColor.getHue(), this.isLuminance ? baseColor.getSaturation() : 1.0, this.isLuminance ? 1.0 : baseColor.getLightness(), baseColor.getOpacity());
        guiGraphics.vLine(this.x + this.width - 3, this.y + 2, this.y + 4, rightColor.toInt());
        for (int i = 0; i < drawWidth; ++i) {
            double val = (double)i / (double)drawWidth;
            HSLColor color1 = HSLColor.hsl(baseColor.getHue(), this.isLuminance ? baseColor.getSaturation() : val, this.isLuminance ? val : baseColor.getLightness(), baseColor.getOpacity());
            guiGraphics.vLine(drawX + i, this.y + 1, this.y + 5, color1.toInt());
        }
        DocClientUtils.blit(guiGraphics, this.knobAsset, this.x + (int)(this.value * (double)(this.width - this.knobAsset.width())), this.y - 1);
        int j = 0xA0A0A0;
        if (this.drawString) {
            guiGraphics.drawString(font, this.getMessage(), this.x + this.width / 4, this.y + (this.height - 32) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
        }
    }
}

