/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectableButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class PropertyButton
extends SelectableButton {
    public ParticleConfigWidgetProvider widgetProvider;
    public int nestLevel = 0;
    public Component fullTitle;
    private List<PropertyButton> children = new ArrayList<PropertyButton>();
    public int index;
    public BaseProperty<?> property;
    public PropertyButton parent;
    private boolean expanded = false;
    public boolean showMarkers = true;

    public PropertyButton(int x, int y, DocAssets.BlitInfo asset, DocAssets.BlitInfo selectedAsset, BaseProperty<?> property, ParticleConfigWidgetProvider widgetProvider, int nestLevel, Button.OnPress onPress) {
        super(x, y, asset, selectedAsset, onPress);
        this.widgetProvider = widgetProvider;
        this.nestLevel = nestLevel;
        this.property = property;
    }

    public void setChildren(List<PropertyButton> children) {
        this.children = children;
        for (PropertyButton child : children) {
            child.parent = this;
        }
    }

    public List<PropertyButton> getChildren() {
        return this.children;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        for (PropertyButton child : this.children) {
            if (child.expanded == expanded) continue;
            child.setExpanded(expanded);
        }
        if (this.parent != null && this.parent.expanded != expanded) {
            this.parent.setExpanded(expanded);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int maxLength;
        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
        this.widgetProvider.renderIcon(graphics, this.x, this.y, pMouseX, pMouseY, pPartialTick);
        Object titleString = this.widgetProvider.getButtonTitle().getString();
        switch (this.nestLevel) {
            case 1: {
                int n = 17;
                break;
            }
            case 2: {
                int n = 12;
                break;
            }
            default: {
                int n = maxLength = 20;
            }
        }
        if (((String)titleString).length() > maxLength + 3) {
            this.fullTitle = Component.literal((String)titleString);
            titleString = ((String)titleString).substring(0, maxLength + 1).trim() + "...";
        } else {
            this.fullTitle = null;
        }
        DocClientUtils.drawStringScaled(graphics, (Component)Component.literal((String)titleString), this.x + 14, this.y + 3, 0, 0.8f, false);
        if (this.showMarkers && this.nestLevel == 0 && !this.children.isEmpty()) {
            if (this.expanded) {
                DocClientUtils.blit(graphics, DocAssets.EXPAND_MARKER, this.x - 7, this.y + 6);
            } else {
                DocClientUtils.blit(graphics, DocAssets.COLLAPSE_MARKER, this.x - 6, this.y + 4);
            }
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.fullTitle != null) {
            tooltip.add(this.fullTitle);
        }
        this.widgetProvider.getButtonTooltips(tooltip);
        super.getTooltip(tooltip);
    }
}

