/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.RenderUtil;

public class EnchantingApparatusRenderer
extends ArsGeoBlockRenderer<EnchantingApparatusTile> {
    public EnchantingApparatusRenderer(BlockEntityRendererProvider.Context p_i226006_1_) {
        super(p_i226006_1_, new GenericModel("enchanting_apparatus"));
    }

    public void renderFinal(PoseStack stack, EnchantingApparatusTile tile, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        super.renderFinal(stack, (GeoAnimatable)tile, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
        GeoBone frame = model.getBone("frame_all").orElse(null);
        if (frame != null && tile.getStack() != null) {
            double x = tile.getBlockPos().getX();
            double y = tile.getBlockPos().getY();
            double z = tile.getBlockPos().getZ();
            if (tile.renderEntity == null || !ItemStack.matches((ItemStack)tile.renderEntity.getItem(), (ItemStack)tile.getStack())) {
                tile.renderEntity = new ItemEntity(tile.getLevel(), x, y, z, tile.getStack());
            }
            stack.pushPose();
            RenderUtil.translateMatrixToBone((PoseStack)stack, (GeoBone)frame);
            Direction facing = (Direction)tile.getBlockState().getValue((Property)BlockStateProperties.FACING);
            stack.translate(0.5 - (double)facing.getStepX() * 0.1, 0.5 - (double)facing.getStepY() * 0.1, 0.5 - (double)facing.getStepZ() * 0.1);
            stack.scale(0.75f, 0.75f, 0.75f);
            stack.mulPose(facing.getRotation());
            ItemStack itemstack = tile.renderEntity.getItem();
            Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, stack, bufferSource, tile.getLevel(), (int)tile.getBlockPos().asLong());
            stack.popPose();
        }
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        if (facing.getAxis().isHorizontal()) {
            Vector3f step = facing.step();
            poseStack.translate((double)(-step.x) * 0.5, 0.5, (double)(-step.z) * 0.5);
        } else if (facing == Direction.DOWN) {
            poseStack.translate(0.0, 1.0, 0.0);
        }
        poseStack.mulPose(facing.getRotation());
    }
}

