/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BasicSpellTurret
extends TickableModBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static HashMap<AbstractCastMethod, ITurretBehavior> TURRET_BEHAVIOR_MAP = new HashMap();
    static final VoxelShape shape;

    public BasicSpellTurret(BlockBehaviour.Properties properties) {
        super(properties.forceSolidOn());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public BasicSpellTurret() {
        this(BasicSpellTurret.defaultProperties().noOcclusion());
    }

    public void tick(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof BasicSpellTurretTile) {
            BasicSpellTurretTile tile = (BasicSpellTurretTile)blockEntity;
            tile.shootSpell();
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean neighborSignal = worldIn.hasNeighborSignal(pos) || worldIn.hasNeighborSignal(pos.above());
        boolean isTriggered = (Boolean)state.getValue((Property)TRIGGERED);
        if (neighborSignal && !isTriggered) {
            worldIn.scheduleTick(pos, (Block)this, 4);
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
        } else if (!neighborSignal && isTriggered) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    public static Position getDispensePosition(BlockPos pos, Direction direction) {
        double d0 = (double)pos.getX() + 0.5 + 0.5 * (double)direction.getStepX();
        double d1 = (double)pos.getY() + 0.5 + 0.5 * (double)direction.getStepY();
        double d2 = (double)pos.getZ() + 0.5 + 0.5 * (double)direction.getStepZ();
        return new Vec3(d0, d1, d2);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction side, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult pHitResult) {
        Spell spell;
        if (handIn != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(handIn);
        if (SpellCasterRegistry.from(stack) != null && !(spell = SpellCasterRegistry.from(stack).getSpell()).isEmpty()) {
            if (spell.getCastMethod() == null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.alert.turret_needs_form"));
                return ItemInteractionResult.SUCCESS;
            }
            if (!TURRET_BEHAVIOR_MAP.containsKey(spell.getCastMethod())) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.alert.turret_type"));
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof BasicSpellTurretTile) {
                BasicSpellTurretTile tile = (BasicSpellTurretTile)blockEntity;
                tile.setSpell(spell);
                tile.setPlayer(player.getUUID());
                tile.updateBlock();
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.alert.spell_set"));
                worldIn.sendBlockUpdated(pos, state, state, 2);
            }
        }
        return super.useItemOn(pStack, state, worldIn, pos, player, handIn, pHitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED, BlockStateProperties.WATERLOGGED});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BasicSpellTurretTile(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return shape;
    }

    protected boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pPathComputationType) {
        return false;
    }

    static {
        TURRET_BEHAVIOR_MAP.put(MethodProjectile.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position iposition, Direction direction) {
                EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                spell.setOwner((Entity)fakePlayer);
                spell.setPos(iposition.x(), iposition.y() - 0.25, iposition.z());
                SpellStats stats = resolver.getCastStats();
                float velocity = Math.max(0.1f, 0.75f + stats.getAccMultiplier() / 2.0f);
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().normalize();
                    spell.shoot(vec3d.x(), vec3d.y(), vec3d.z(), velocity, 0.0f);
                } else {
                    spell.shoot(direction.getStepX(), direction.getStepY(), direction.getStepZ(), velocity, 0.0f);
                }
                world.addFreshEntity((Entity)spell);
            }
        });
        TURRET_BEHAVIOR_MAP.put(MethodTouch.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel serverLevel, BlockPos pos, Player fakePlayer, Position dispensePosition, Direction facingDir) {
                BlockPos touchPos = pos.relative(facingDir);
                List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(touchPos));
                if (!entityList.isEmpty()) {
                    LivingEntity entity = (LivingEntity)entityList.get(serverLevel.random.nextInt(entityList.size()));
                    resolver.onCastOnEntity(ItemStack.EMPTY, (Entity)entity, InteractionHand.MAIN_HAND);
                } else {
                    Vec3 hitVec = new Vec3((double)touchPos.getX() + (double)facingDir.getStepX() * 0.5, (double)touchPos.getY() + (double)facingDir.getStepY() * 0.5, (double)touchPos.getZ() + (double)facingDir.getStepZ() * 0.5);
                    resolver.onCastOnBlock(new BlockHitResult(hitVec, facingDir.getOpposite(), new BlockPos(touchPos.getX(), touchPos.getY(), touchPos.getZ()), true));
                }
            }
        });
        shape = Block.box((double)4.6, (double)4.6, (double)4.6, (double)11.6, (double)11.6, (double)11.6);
    }
}

