/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import com.hollingsworth.arsnouveau.common.block.tile.DrygmyTile;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DrygmyStone
extends SummonBlock
implements SimpleWaterloggedBlock {
    public static VoxelShape shape = Stream.of(Block.box((double)16.0, (double)3.0, (double)9.5, (double)16.0, (double)6.0, (double)11.5), Block.box((double)9.0, (double)0.0, (double)0.5, (double)12.0, (double)5.0, (double)2.5), Block.box((double)4.0, (double)0.0, (double)0.5, (double)7.0, (double)5.0, (double)2.5), Block.box((double)3.5, (double)5.0, (double)0.0, (double)12.5, (double)7.0, (double)3.0), Block.box((double)13.5, (double)0.0, (double)4.0, (double)15.5, (double)6.0, (double)7.0), Block.box((double)13.5, (double)0.0, (double)9.0, (double)15.5, (double)6.0, (double)12.0), Block.box((double)13.0, (double)6.0, (double)3.5, (double)16.0, (double)8.0, (double)12.5), Block.box((double)4.0, (double)0.0, (double)13.5, (double)7.0, (double)7.0, (double)15.5), Block.box((double)9.0, (double)0.0, (double)13.5, (double)12.0, (double)7.0, (double)15.5), Block.box((double)3.5, (double)7.0, (double)13.0, (double)12.5, (double)9.0, (double)16.0), Block.box((double)0.5, (double)0.0, (double)4.0, (double)2.5, (double)8.0, (double)7.0), Block.box((double)0.5, (double)0.0, (double)9.0, (double)2.5, (double)8.0, (double)12.0), Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), Block.box((double)0.0, (double)8.0, (double)3.5, (double)3.0, (double)10.0, (double)12.5), Block.box((double)10.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0), Block.box((double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)6.0), Block.box((double)6.5, (double)1.0, (double)0.0, (double)10.5, (double)5.0, (double)0.0), Block.box((double)5.5, (double)2.0, (double)3.0, (double)8.5, (double)5.0, (double)3.0), Block.box((double)4.5, (double)5.0, (double)16.0, (double)8.5, (double)7.0, (double)16.0), Block.box((double)9.5, (double)3.0, (double)13.0, (double)11.5, (double)7.0, (double)13.0), Block.box((double)16.0, (double)4.0, (double)4.5, (double)16.0, (double)6.0, (double)8.5), Block.box((double)3.0, (double)4.0, (double)5.5, (double)3.0, (double)8.0, (double)9.5), Block.box((double)0.0, (double)4.0, (double)5.5, (double)0.0, (double)8.0, (double)7.5), Block.box((double)0.0, (double)3.0, (double)8.5, (double)0.0, (double)8.0, (double)11.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(Shapes.block());

    public DrygmyStone() {
        super(DrygmyStone.defaultProperties().noOcclusion().lightLevel(b -> 8));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DrygmyTile(pos, state);
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return shape;
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.isClientSide() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof DrygmyTile) {
            DrygmyTile henge = (DrygmyTile)blockEntity;
            henge.isOff = pLevel.hasNeighborSignal(pPos);
            henge.updateBlock();
        }
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

