/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AlterationTile
extends ModdedTile
implements GeoBlockEntity,
ITickable {
    public ItemStack armorStack = ItemStack.EMPTY;
    public ItemEntity renderEntity;
    public List<ItemStack> perkList = new ArrayList<ItemStack>();
    public int newPerkTimer = 0;
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AlterationTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AlterationTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.ARMOR_TILE, pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Nullable
    public AlterationTile getLogicTile() {
        AlterationTile tile = this;
        if (!this.isMasterTile()) {
            AlterationTile alterationTile;
            BlockEntity tileEntity = this.level.getBlockEntity(this.getBlockPos().relative(AlterationTable.getConnectedDirection(this.getBlockState())));
            tile = tileEntity instanceof AlterationTile ? (alterationTile = (AlterationTile)tileEntity) : null;
        }
        return tile;
    }

    public boolean isMasterTile() {
        return this.getBlockState().getValue((Property)AlterationTable.PART) == ThreePartBlock.HEAD;
    }

    public void setArmorStack(ItemStack stack, Player player) {
        ArmorPerkHolder holder = (ArmorPerkHolder)stack.getOrDefault(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(null, List.of(), 0, new HashMap<IPerk, CompoundTag>()));
        this.perkList = new ArrayList<ItemStack>(PerkUtil.getPerksAsItems(stack).stream().map(Item::getDefaultInstance).toList());
        stack.set(DataComponentRegistry.ARMOR_PERKS, holder.setPerks((List)new ArrayList()));
        this.armorStack = stack.copy();
        if (!player.hasInfiniteMaterials()) {
            stack.shrink(1);
        }
        this.newPerkTimer = 0;
        this.updateBlock();
    }

    public void removePerk(Player player) {
        if (!this.perkList.isEmpty()) {
            ItemStack stack = this.perkList.get(0);
            if (!player.addItem(stack.copy())) {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.position().x(), player.position().y(), player.position().z(), stack.copy()));
            }
            this.perkList.remove(0);
        }
        this.updateBlock();
    }

    public void removeArmorStack(Player player) {
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(this.armorStack);
        HashMap<IPerk, CompoundTag> perkTags = new HashMap<IPerk, CompoundTag>();
        Object newHolder = perkHolder.setPerks(new ArrayList<IPerk>(this.perkList.stream().map(i -> {
            Item patt0$temp = i.getItem();
            if (patt0$temp instanceof PerkItem) {
                PerkItem perkItem = (PerkItem)patt0$temp;
                IPerk perk = perkItem.perk;
                CompoundTag initTag = perk.getInitTag();
                if (initTag != null && perkHolder.getTagForPerk(perk) == null) {
                    perkTags.put(perk, initTag);
                }
                return perk;
            }
            return null;
        }).filter(Objects::nonNull).toList()));
        ItemStack copyStack = this.armorStack.copy();
        copyStack.set(DataComponentRegistry.ARMOR_PERKS, (Object)((ArmorPerkHolder)newHolder).setPerkTags(perkTags));
        if (!player.addItem(copyStack)) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.position().x(), player.position().y(), player.position().z(), copyStack));
        }
        this.armorStack = ItemStack.EMPTY;
        this.perkList = new ArrayList<ItemStack>();
        this.updateBlock();
    }

    public void addPerkStack(ItemStack stack, Player player) {
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(this.armorStack);
        if (perkHolder == null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.perk.set_armor"));
            return;
        }
        if (this.perkList.size() >= 3 || this.perkList.size() >= perkHolder.getSlotsForTier(this.armorStack).size()) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.perk.max_perks"));
            return;
        }
        PerkSlot foundSlot = this.getAvailableSlot(perkHolder);
        Item item = stack.getItem();
        if (item instanceof PerkItem) {
            PerkItem perkItem = (PerkItem)item;
            IPerk perk = perkItem.perk;
            if (foundSlot != null && perk.validForSlot(foundSlot, this.armorStack, player)) {
                this.perkList.add(stack.split(1));
                if (this.newPerkTimer <= 0) {
                    this.newPerkTimer = 40;
                }
                this.updateBlock();
            }
        }
    }

    private PerkSlot getAvailableSlot(ArmorPerkHolder perkHolder) {
        if (this.perkList.size() >= perkHolder.getSlotsForTier(this.armorStack).size()) {
            return null;
        }
        return perkHolder.getSlotsForTier(this.armorStack).get(this.perkList.size());
    }

    public void dropItems() {
        if (!this.armorStack.isEmpty()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), this.armorStack.copy()));
            this.armorStack = ItemStack.EMPTY;
        }
        for (ItemStack stack : this.perkList) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), stack.copy()));
            stack.setCount(0);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.armorStack.isEmpty()) {
            Tag armorTag = this.armorStack.save(pRegistries);
            tag.put("armorStack", armorTag);
        }
        tag.putInt("numPerks", this.perkList.size());
        int count = 0;
        for (ItemStack i : this.perkList) {
            Tag perkTag = i.saveOptional(pRegistries);
            tag.put("perk" + count, perkTag);
            ++count;
        }
        tag.putInt("newPerkTimer", this.newPerkTimer);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.armorStack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("armorStack"));
        int count = compound.getInt("numPerks");
        this.perkList = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            CompoundTag perkTag = compound.getCompound("perk" + i);
            ItemStack perk = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)perkTag);
            if (perk.isEmpty()) continue;
            this.perkList.add(perk);
        }
        this.newPerkTimer = compound.getInt("newPerkTimer");
    }

    @Override
    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level.isClientSide && this.newPerkTimer >= 0) {
            --this.newPerkTimer;
        }
    }
}

