/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.RitualBrazierBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BrazierRelayTile
extends RitualBrazierTile {
    int ticksToLightOff = 0;
    public BlockPos brazierPos;
    private static List<BlockPos> relayingTraversed = new ArrayList<BlockPos>();

    public BrazierRelayTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public BrazierRelayTile(BlockPos p, BlockState s) {
        super((BlockEntityType)BlockRegistry.BRAZIER_RELAY_TILE.get(), p, s);
    }

    @Override
    public void tick() {
        if (this.isDecorative && this.level.isClientSide) {
            this.makeParticle(this.color.nextColor((int)this.level.getGameTime() * 10), this.color.nextColor((int)this.level.getGameTime() * 10), 5);
        }
        if (!this.level.isClientSide) {
            --this.ticksToLightOff;
            if (this.ticksToLightOff <= 0) {
                this.ticksToLightOff = 0;
                if (!this.isDecorative && ((Boolean)this.level.getBlockState(this.worldPosition).getValue(RitualBrazierBlock.LIT)).booleanValue()) {
                    this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue(RitualBrazierBlock.LIT)).booleanValue() && this.ticksToLightOff > 0) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    @Override
    public void makeParticle(ParticleColor centerColor, ParticleColor outerColor, int intensity) {
        int i;
        Level world = this.getLevel();
        BlockPos pos = this.getBlockPos();
        double xzOffset = 0.25;
        for (i = 0; i < intensity; ++i) {
            world.addParticle(GlowParticleData.createData(centerColor.nextColor((int)this.level.getGameTime() * 20)), (double)pos.getX() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), (double)pos.getY() + 0.2 + ParticleUtil.inRange(-0.05, 0.2), (double)pos.getZ() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
        }
        for (i = 0; i < intensity; ++i) {
            world.addParticle(GlowParticleData.createData(outerColor.nextColor((int)this.level.getGameTime() * 20)), (double)pos.getX() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), (double)pos.getY() + 0.2 + ParticleUtil.inRange(0.0, 0.7), (double)pos.getZ() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
        }
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity blockEntity;
        if (storedPos != null && this.level != null && (blockEntity = this.level.getBlockEntity(storedPos)) instanceof RitualBrazierTile) {
            RitualBrazierTile brazierTile = (RitualBrazierTile)blockEntity;
            if (BlockUtil.distanceFrom(this.getBlockPos(), storedPos) > 16.0) {
                return;
            }
            this.brazierPos = storedPos;
            this.updateBlock();
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("ticksToLightOff", this.ticksToLightOff);
        if (this.brazierPos != null) {
            tag.putLong("brazierPos", this.brazierPos.asLong());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.ticksToLightOff = tag.getInt("ticksToLightOff");
        if (tag.contains("brazierPos")) {
            this.brazierPos = BlockPos.of((long)tag.getLong("brazierPos"));
        }
    }

    @Override
    public InventoryManager getInventoryManager() {
        BlockEntity blockEntity;
        if (this.brazierPos != null && this.level != null && relayingTraversed.size() < 256 && !relayingTraversed.contains(this.brazierPos) && this.level.isLoaded(this.brazierPos) && (blockEntity = this.level.getBlockEntity(this.brazierPos)) instanceof RitualBrazierTile) {
            RitualBrazierTile brazierTile = (RitualBrazierTile)blockEntity;
            relayingTraversed.add(this.brazierPos);
            InventoryManager brazierInv = brazierTile.getInventoryManager();
            if (!brazierInv.getInventory().isEmpty()) {
                relayingTraversed.clear();
                return brazierInv;
            }
        }
        relayingTraversed.clear();
        return super.getInventoryManager();
    }
}

