/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SourcelinkTile
extends AbstractSourceMachine
implements GeoBlockEntity,
ITickable {
    int progress;
    public boolean isDisabled = false;
    public boolean registered = false;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SourcelinkTile(BlockEntityType<?> sourceLinkTile, BlockPos pos, BlockState state) {
        super(sourceLinkTile, pos, state);
    }

    @Override
    public void tick() {
        List<ISpecialSourceProvider> providers;
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 120L == 0L && this.usesEventQueue()) {
            SourcelinkEventQueue.addPosition(this.level, this.worldPosition);
            this.registered = true;
        }
        if (this.level.getGameTime() % 100L == 0L && this.getSource() > 0 && !(providers = SourceUtil.canGiveSource(this.worldPosition, this.level, 5)).isEmpty()) {
            this.transferSource(this, providers.getFirst().getSource());
            ParticleUtil.spawnFollowProjectile(this.level, this.worldPosition, providers.getFirst().getCurrentPos(), this.getColor());
        }
    }

    public List<ArcanePedestalTile> getSurroundingPedestals() {
        ArrayList<ArcanePedestalTile> inventories = new ArrayList<ArcanePedestalTile>();
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)this.getBlockPos().below().east().north(), (BlockPos)this.getBlockPos().above().west().south())) {
            BlockEntity blockEntity = this.level.getBlockEntity(p);
            if (!(blockEntity instanceof ArcanePedestalTile)) continue;
            ArcanePedestalTile pedestal = (ArcanePedestalTile)blockEntity;
            inventories.add(pedestal);
        }
        return inventories;
    }

    public void getManaEvent(BlockPos sourcePos, int total) {
        this.addSource(total);
        ParticleUtil.spawnFollowProjectile(this.level, sourcePos, this.worldPosition, this.getColor());
    }

    public boolean eventInRange(BlockPos sourcePos, @Nullable Event event) {
        return BlockUtil.distanceFrom(this.worldPosition, sourcePos) <= 15.0;
    }

    public boolean usesEventQueue() {
        return false;
    }

    public void doRandomAction() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.progress = tag.getInt("progress");
        this.isDisabled = tag.getBoolean("disabled");
    }

    @Override
    @NotNull
    protected SourceStorage createDefaultStorage() {
        return new SourceStorage(this, 20000, 10000, 10000, 0){

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("progress", this.progress);
        tag.putBoolean("disabled", this.isDisabled);
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationState<E> event) {
        if (this.isDisabled) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        return PlayState.CONTINUE;
    }
}

