/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.DropDistribution;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WhirlisprigTile
extends SummoningTile
implements GeoBlockEntity {
    public static TagKey<Block> KINDA_LIKES = BlockTags.create((ResourceLocation)ArsNouveau.prefix("whirlisprig/kinda_likes"));
    public static TagKey<Block> GREATLY_LIKES = BlockTags.create((ResourceLocation)ArsNouveau.prefix("whirlisprig/greatly_likes"));
    public static TagKey<Item> DENIED_DROP = ItemTags.create((ResourceLocation)ArsNouveau.prefix("whirlisprig/denied_drop"));
    public List<ItemStack> ignoreItems = new ArrayList<ItemStack>();
    public int ticksToNextEval;
    public int moodScore;
    public int diversityScore;
    public int progress;
    public Map<BlockState, Integer> genTable = new HashMap<BlockState, Integer>();
    public Map<BlockState, Integer> scoreMap = new HashMap<BlockState, Integer>();
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WhirlisprigTile(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)BlockRegistry.WHIRLISPRIG_TILE.get(), pPos, pState);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            for (int i = 0; i < this.progress / 20; ++i) {
                this.level.addParticle(GlowParticleData.createData(new ParticleColor(50, 255, 20)), (double)this.getBlockPos().getX() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), (double)this.getBlockPos().getY() + 1.3 + ParticleUtil.inRange(-0.1, 0.1), (double)this.getBlockPos().getZ() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), 0.0, 0.0, 0.0);
            }
        }
        if (!this.level.isClientSide) {
            if (this.ticksToNextEval > 0) {
                --this.ticksToNextEval;
            }
            if (this.ticksToNextEval <= 0) {
                this.evaluateGrove();
            }
            if (this.level.getGameTime() % 60L == 0L && this.progress >= (Integer)Config.WHIRLISPRIG_MAX_PROGRESS.get() && SourceUtil.takeSourceMultipleWithParticles(this.worldPosition, this.level, 5, (Integer)Config.WHIRLISPRIG_SOURCE_COST.get()) != null) {
                this.progress = 0;
                DropDistribution<BlockState> blockDropDistribution = new DropDistribution<BlockState>(this.genTable);
                int numDrops = this.getDropsByDiversity() + 3;
                for (int i = 0; i < numDrops; ++i) {
                    BlockState block = blockDropDistribution.nextDrop();
                    if (block == null) {
                        return;
                    }
                    for (ItemStack s : this.getDrops(blockDropDistribution)) {
                        BlockUtil.insertItemAdjacent(this.level, this.worldPosition, s);
                    }
                }
                this.updateBlock();
            }
        }
    }

    public boolean isValidReward(ItemStack stack) {
        if (stack.is(DENIED_DROP)) {
            return false;
        }
        if (this.ignoreItems == null || this.ignoreItems.isEmpty()) {
            return true;
        }
        return this.ignoreItems.stream().noneMatch(i -> ItemStack.isSameItem((ItemStack)i, (ItemStack)stack));
    }

    public int getDropsByDiversity() {
        return this.diversityScore / 2;
    }

    public List<ItemStack> getDrops(DropDistribution<BlockState> blockDropDistribution) {
        Supplier<List> getDrops = () -> Block.getDrops((BlockState)((BlockState)blockDropDistribution.nextDrop()), (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition, null);
        boolean bonusReroll = false;
        for (int numRerolls = 0; numRerolls < (bonusReroll ? 16 : 8); ++numRerolls) {
            List drops = getDrops.get();
            if (drops.isEmpty()) continue;
            List successfulDrops = drops.stream().filter(this::isValidReward).collect(Collectors.toCollection(ArrayList::new));
            bonusReroll = true;
            if (successfulDrops.isEmpty()) continue;
            return successfulDrops;
        }
        return new ArrayList<ItemStack>();
    }

    public void addProgress() {
        this.progress += this.moodScore / 30;
        if (this.progress > (Integer)Config.WHIRLISPRIG_MAX_PROGRESS.get()) {
            this.progress = (Integer)Config.WHIRLISPRIG_MAX_PROGRESS.get();
        }
        this.updateBlock();
    }

    public void evaluateGrove() {
        Level world = this.getLevel();
        HashMap<BlockState, Integer> defaultMap = new HashMap<BlockState, Integer>();
        HashMap<BlockState, Integer> dropMap = new HashMap<BlockState, Integer>();
        int score = 0;
        for (BlockPos b : BlockPos.betweenClosed((BlockPos)this.getBlockPos().north(10).west(10).below(1), (BlockPos)this.getBlockPos().south(10).east(10).above(30))) {
            BlockState state = world.getBlockState(b);
            BlockState defaultState = state.getBlock().defaultBlockState();
            int points = WhirlisprigTile.getScore(defaultState);
            if (world.isOutsideBuildHeight(b) || points == 0) continue;
            if (!defaultMap.containsKey(defaultState)) {
                defaultMap.put(defaultState, 0);
            }
            if (!dropMap.containsKey(state)) {
                dropMap.put(state, 0);
            }
            if (!state.hasBlockEntity()) {
                dropMap.put(state, (Integer)dropMap.get(state) + 1);
            }
            defaultMap.put(defaultState, (Integer)defaultMap.get(defaultState) + 1);
            score += (Integer)defaultMap.get(defaultState) <= 50 ? points : 0;
        }
        this.ticksToNextEval = 2400;
        this.genTable = dropMap;
        this.scoreMap = defaultMap;
        this.diversityScore = defaultMap.keySet().size();
        this.moodScore = score;
    }

    public static int getScore(BlockState state) {
        if (state.isAir()) {
            return 0;
        }
        if (state == Blocks.WATER.defaultBlockState() || state == Blocks.GRASS_BLOCK.defaultBlockState() || state == Blocks.PODZOL.defaultBlockState() || state == Blocks.DIRT_PATH.defaultBlockState()) {
            return 1;
        }
        if (state.getBlock() instanceof BushBlock) {
            return 2;
        }
        if (state.is(BlockTagProvider.HARVEST_STEMS)) {
            return 2;
        }
        if (state.is(BlockTags.LOGS)) {
            return 2;
        }
        if (state.is(BlockTags.LEAVES) || state.getBlock() instanceof LeavesBlock) {
            return 1;
        }
        if (state.getBlock() instanceof BonemealableBlock) {
            return 1;
        }
        if (state.is(KINDA_LIKES)) {
            return 1;
        }
        if (state.is(GREATLY_LIKES)) {
            return 2;
        }
        return 0;
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.level != null && !this.level.isClientSide) {
            if (this.tickCounter >= 120) {
                this.converted = true;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
                Whirlisprig entityWhirlisprig = new Whirlisprig(this.level, true, new BlockPos((Vec3i)this.getBlockPos()));
                entityWhirlisprig.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5);
                this.level.addFreshEntity((Entity)entityWhirlisprig);
                ParticleUtil.spawnPoof((ServerLevel)this.level, this.worldPosition.above());
                this.tickCounter = 0;
                return;
            }
            if (this.tickCounter % 10 == 0) {
                RandomSource r = this.level.random;
                int min = -2;
                int max = 2;
                EntityFollowProjectile proj1 = new EntityFollowProjectile(this.level, this.worldPosition.offset(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.worldPosition, r.nextInt(255), r.nextInt(255), r.nextInt(255));
                this.level.addFreshEntity((Entity)proj1);
            }
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("moodScore", this.moodScore);
        tag.putInt("diversityScore", this.diversityScore);
        tag.putInt("progress", this.progress);
        tag.putInt("evalTicks", this.ticksToNextEval);
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(pRegistries, tag, "ignored_", this.ignoreItems);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.moodScore = compound.getInt("moodScore");
        this.diversityScore = compound.getInt("diversityScore");
        this.progress = compound.getInt("progress");
        this.ticksToNextEval = compound.getInt("evalTicks");
        this.ignoreItems = NBTUtil.readItems(pRegistries, compound, "ignored_");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "rotateController", 1, this::walkPredicate));
    }

    private <T extends GeoAnimatable> PlayState walkPredicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("spin"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

