/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class CrushRecipeProvider
extends SimpleDataProvider {
    public List<CrushWrapper> recipes = new ArrayList<CrushWrapper>();

    public CrushRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.recipes.add(new CrushWrapper("stone", Ingredient.of((TagKey)Tags.Items.STONES)).withItems(Items.GRAVEL.getDefaultInstance(), 1.0f));
        this.recipes.add(new CrushWrapper("gravel", Ingredient.of((TagKey)Tags.Items.GRAVELS)).withItems(Items.SAND.getDefaultInstance(), 1.0f).withItems(Items.FLINT.getDefaultInstance(), 0.02f));
        this.recipes.add(new CrushWrapper("cobblestone", Ingredient.of((TagKey)Tags.Items.COBBLESTONES)).withItems(Items.GRAVEL.getDefaultInstance(), 1.0f));
        this.recipes.add(new CrushWrapper("white_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.LILY_OF_THE_VALLEY})).withItems(new ItemStack((ItemLike)Items.WHITE_DYE, 2)));
        this.recipes.add(new CrushWrapper("orange_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_TULIP})).withItems(new ItemStack((ItemLike)Items.ORANGE_DYE, 2)));
        this.recipes.add(new CrushWrapper("magenta_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.ALLIUM})).withItems(new ItemStack((ItemLike)Items.MAGENTA_DYE, 2)));
        this.recipes.add(new CrushWrapper("light_blue_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ORCHID})).withItems(new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE, 2)));
        this.recipes.add(new CrushWrapper("yellow_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.DANDELION})).withItems(new ItemStack((ItemLike)Items.YELLOW_DYE, 2)));
        this.recipes.add(new CrushWrapper("pink_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_TULIP})).withItems(new ItemStack((ItemLike)Items.PINK_DYE, 2)));
        this.recipes.add(new CrushWrapper("light_gray_dye_oxeye", Ingredient.of((ItemLike[])new ItemLike[]{Items.OXEYE_DAISY})).withItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2)));
        this.recipes.add(new CrushWrapper("light_gray_dye_azure", Ingredient.of((ItemLike[])new ItemLike[]{Items.AZURE_BLUET})).withItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2)));
        this.recipes.add(new CrushWrapper("light_gray_dye_tulip", Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_TULIP})).withItems(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2)));
        this.recipes.add(new CrushWrapper("blue_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.CORNFLOWER})).withItems(new ItemStack((ItemLike)Items.BLUE_DYE, 2)));
        this.recipes.add(new CrushWrapper("brown_dye", Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS})).withItems(new ItemStack((ItemLike)Items.BROWN_DYE, 2)));
        this.recipes.add(new CrushWrapper("red_dye_tulip", Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_TULIP})).withItems(new ItemStack((ItemLike)Items.RED_DYE, 2)));
        this.recipes.add(new CrushWrapper("red_dye_beetroot", Ingredient.of((ItemLike[])new ItemLike[]{Items.BEETROOT})).withItems(new ItemStack((ItemLike)Items.RED_DYE, 2)));
        this.recipes.add(new CrushWrapper("red_dye_poppy", Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPY})).withItems(new ItemStack((ItemLike)Items.RED_DYE, 2)));
        this.recipes.add(new CrushWrapper("red_dye_rose_bush", Ingredient.of((ItemLike[])new ItemLike[]{Items.ROSE_BUSH})).withItems(new ItemStack((ItemLike)Items.RED_DYE, 4)));
        this.recipes.add(new CrushWrapper("yellow_dye_sunflower", Ingredient.of((ItemLike[])new ItemLike[]{Items.SUNFLOWER})).withItems(new ItemStack((ItemLike)Items.YELLOW_DYE, 4)));
        this.recipes.add(new CrushWrapper("magenta_dye_lilac", Ingredient.of((ItemLike[])new ItemLike[]{Items.LILAC})).withItems(new ItemStack((ItemLike)Items.MAGENTA_DYE, 4)));
        this.recipes.add(new CrushWrapper("pink_dye_peony", Ingredient.of((ItemLike[])new ItemLike[]{Items.PEONY})).withItems(new ItemStack((ItemLike)Items.PINK_DYE, 4)));
        this.recipes.add(new CrushWrapper("terracotta", Ingredient.of((ItemLike[])new ItemLike[]{Items.TERRACOTTA})).withItems(Items.RED_SAND.getDefaultInstance()));
        this.recipes.add(new CrushWrapper("sugar_cane", Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE})).withItems(new ItemStack((ItemLike)Items.SUGAR, 2)));
        this.recipes.add(new CrushWrapper("sandstone_to_sand", Ingredient.of((ItemLike[])new ItemLike[]{Items.SANDSTONE})).withItems(Items.SAND.getDefaultInstance()));
        this.recipes.add(new CrushWrapper("quartz_block_to_quartz", Ingredient.of(ItemTagProvider.STORAGE_BLOCKS_QUARTZ)).withItems(new ItemStack((ItemLike)Items.QUARTZ, 4)));
        this.recipes.add(new CrushWrapper("glowstone_block_to_dust", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GLOWSTONE})).withItems(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 4)));
        for (CrushWrapper g : this.recipes) {
            Path path = CrushRecipeProvider.getRecipePath(this.output, g.path.getPath());
            this.saveStable(pOutput, (JsonElement)CrushRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.asRecipe()).getOrThrow(), path);
        }
    }

    private static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipe/" + str + ".json");
    }

    public String getName() {
        return "Crush";
    }

    public static class CrushWrapper {
        public ResourceLocation path;
        public Ingredient ing;
        List<CrushRecipe.CrushOutput> outputs = new ArrayList<CrushRecipe.CrushOutput>();

        public CrushWrapper(String string, Ingredient ingredient) {
            this.path = ArsNouveau.prefix(string);
            this.ing = ingredient;
        }

        public CrushWrapper withItems(ItemStack output, float chance) {
            this.outputs.add(new CrushRecipe.CrushOutput(output, chance));
            return this;
        }

        public CrushWrapper withItems(ItemStack output) {
            this.outputs.add(new CrushRecipe.CrushOutput(output, 1.0f));
            return this;
        }

        public CrushRecipe asRecipe() {
            return new CrushRecipe(this.ing, this.outputs);
        }
    }
}

