/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.lily.IAdorable;
import com.hollingsworth.arsnouveau.common.entity.goal.lily.WagGoal;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Lily
extends TamableAnimal
implements GeoEntity,
IDispellable,
IAdorable {
    public static BiMap<UUID, UUID> ownerLilyMap = HashBiMap.create();
    private static final EntityDataAccessor<Boolean> SIT = SynchedEntityData.defineId(Lily.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WAG = SynchedEntityData.defineId(Lily.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int wagTicks;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Lily(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Lily(Level level) {
        this((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.LILY.get()), level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, new WagGoal<Lily>(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        if (this.level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (this.isOwnedBy((LivingEntity)pPlayer)) {
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level.isClientSide) {
            if (this.level.getGameTime() % 20L == 0L && !ownerLilyMap.containsValue((Object)this.getUUID())) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            if (this.wagTicks > 0 && this.isWagging()) {
                --this.wagTicks;
                if (this.wagTicks <= 0) {
                    this.setWagging(false);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SIT, (Object)false);
        pBuilder.define(WAG, (Object)false);
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(SIT);
    }

    public boolean isTame() {
        return true;
    }

    public void setOrderedToSit(boolean pOrderedToSit) {
        this.entityData.set(SIT, (Object)pOrderedToSit);
    }

    public boolean isWagging() {
        return (Boolean)this.entityData.get(WAG);
    }

    @Override
    public void setWagging(boolean pWagging) {
        this.entityData.set(WAG, (Object)pWagging);
    }

    @Override
    public void setWagTicks(int ticks) {
        this.wagTicks = ticks;
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected SoundEvent getAmbientSound() {
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 10.0f ? SoundEvents.WOLF_WHINE : SoundEvents.WOLF_PANT;
        }
        return SoundEvents.WOLF_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (!(pSource.getEntity() instanceof Player)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(ItemTags.WOLF_FOOD);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "walk", 1, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "idle", 1, event -> {
            if (!event.isMoving() && !this.isWagging()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "idle_wag", 1, event -> {
            if (!event.isMoving() && this.isWagging()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("idle_wagging"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "rest", 1, event -> {
            if (!event.isMoving() && this.isOrderedToSit() && !this.isWagging()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("resting"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "rest_wag", 1, event -> {
            if (!event.isMoving() && this.isOrderedToSit() && this.isWagging()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("resting_wagging"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (caster.getUUID().equals(this.getOwnerUUID())) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        if (!ownerLilyMap.containsKey((Object)this.getOwnerUUID())) {
            ownerLilyMap.put((Object)this.getOwnerUUID(), (Object)this.getUUID());
        }
    }
}

