/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MultiPotionContents(int charges, PotionContents contents, int maxUses) implements IPotionProvider
{
    public static Codec<MultiPotionContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("charges").forGetter(MultiPotionContents::charges), (App)PotionContents.CODEC.fieldOf("contents").forGetter(MultiPotionContents::contents), (App)Codec.INT.fieldOf("maxUses").forGetter(MultiPotionContents::maxUses)).apply((Applicative)instance, MultiPotionContents::new));
    public static StreamCodec<RegistryFriendlyByteBuf, MultiPotionContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MultiPotionContents::charges, (StreamCodec)PotionContents.STREAM_CODEC, MultiPotionContents::contents, (StreamCodec)ByteBufCodecs.INT, MultiPotionContents::maxUses, MultiPotionContents::new);

    public MultiPotionContents withCharges(int charges) {
        return new MultiPotionContents(charges, this.contents, this.maxUses);
    }

    public MultiPotionContents withMaxUses(int maxUses) {
        return new MultiPotionContents(this.charges, this.contents, maxUses);
    }

    public MultiPotionContents withContents(PotionContents contents) {
        return new MultiPotionContents(this.charges, contents, this.maxUses);
    }

    @Override
    @NotNull
    public PotionContents getPotionData(ItemStack stack) {
        return this.contents;
    }

    @Override
    public int usesRemaining(ItemStack stack) {
        return this.charges;
    }

    @Override
    public int maxUses(ItemStack stack) {
        return this.maxUses;
    }

    @Override
    public void consumeUses(ItemStack stack, int amount, @Nullable LivingEntity player) {
        stack.set(DataComponentRegistry.MULTI_POTION, (Object)this.withCharges(this.charges - amount));
    }

    @Override
    public void addUse(ItemStack stack, int amount, @Nullable LivingEntity player) {
        stack.set(DataComponentRegistry.MULTI_POTION, (Object)this.withCharges(this.charges + amount));
    }

    @Override
    public void setData(PotionContents contents, int usesRemaining, int maxUses, ItemStack stack) {
        stack.set(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(usesRemaining, contents, maxUses));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPotionContents that = (MultiPotionContents)o;
        return this.charges == that.charges && this.maxUses == that.maxUses && Objects.equals(this.contents, that.contents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.charges, this.contents, this.maxUses);
    }
}

