/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.event.PlayerPostLogOutEvent;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.LevelPosMap;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="ars_nouveau")
public class CatBehavior
extends JarBehavior<Cat> {
    public static LevelPosMap CAT_MAP = new LevelPosMap((level, pos) -> {
        MobJarTile mobJarTile;
        BlockEntity patt0$temp = level.getBlockEntity(pos);
        return !(patt0$temp instanceof MobJarTile) || !((mobJarTile = (MobJarTile)patt0$temp).getEntity() instanceof Cat);
    });

    @Override
    public void tick(MobJarTile tile) {
        Level level = tile.getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        BlockPos pos = tile.getBlockPos();
        if (level.getGameTime() % 20L == 0L) {
            CAT_MAP.addPosition(level, pos);
        }
    }

    @Override
    public int getSignalPower(MobJarTile tile) {
        Level level = tile.getLevel();
        if (!(level instanceof ServerLevel)) {
            return super.getSignalPower(tile);
        }
        Cat cat = (Cat)this.entityFromJar(tile);
        return cat.getOwner() == null ? 0 : 15;
    }

    private static void updateOwnedJars(@NotNull Player player) {
        Level level = player.level;
        Set<BlockPos> map = CatBehavior.CAT_MAP.posMap.get(level.dimension().location().toString());
        if (map == null) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos pos : map) {
            MobJarTile jar;
            if (!level.isLoaded(pos)) continue;
            if (CatBehavior.CAT_MAP.removeFunction.apply(level, pos).booleanValue()) {
                stale.add(pos);
                continue;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof MobJarTile) || !((blockEntity = (jar = (MobJarTile)blockEntity).getEntity()) instanceof Cat)) continue;
            Cat cat = (Cat)blockEntity;
            if (!player.getUUID().equals(cat.getOwnerUUID())) continue;
            level.updateNeighborsAt(pos, jar.getBlockState().getBlock());
        }
        for (BlockPos pos : stale) {
            map.remove(pos);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        CatBehavior.updateOwnedJars(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLeft(PlayerPostLogOutEvent event) {
        CatBehavior.updateOwnedJars(event.getEntity());
    }

    @SubscribeEvent
    public static void sleepEvent(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        String key = level.dimension().location().toString();
        if (!CatBehavior.CAT_MAP.posMap.containsKey(key)) {
            return;
        }
        Set positions = CatBehavior.CAT_MAP.posMap.getOrDefault(key, new HashSet());
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos p : positions) {
            Player owner;
            Cat cat;
            MobJarTile tile;
            block10: {
                block9: {
                    if (!level.isLoaded(p)) continue;
                    if (CatBehavior.CAT_MAP.removeFunction.apply((Level)level, p).booleanValue()) {
                        stale.add(p);
                        continue;
                    }
                    tile = (MobJarTile)level.getBlockEntity(p);
                    cat = (Cat)tile.getEntity();
                    LivingEntity livingEntity = cat.getOwner();
                    if (!(livingEntity instanceof Player)) break block9;
                    owner = (Player)livingEntity;
                    if (!(cat.getRandom().nextFloat() > 0.7f)) break block10;
                }
                return;
            }
            if (!(owner.distanceToSqr((Entity)cat) <= 100.0) || owner.getSleepTimer() < 100) continue;
            LootTable loottable = level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.CAT_MORNING_GIFT);
            LootParams lootparams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)cat.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)cat).create(LootContextParamSets.GIFT);
            for (ItemStack itemstack : loottable.getRandomItems(lootparams)) {
                JarBehavior.insertOrCreateItem(tile, itemstack);
            }
        }
        for (BlockPos pos : stale) {
            CatBehavior.CAT_MAP.posMap.get(key).remove(pos);
        }
    }
}

