/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class UpdateStorageItemsPacket
extends AbstractPacket {
    public List<StoredItemStack> stacks;
    public static final CustomPacketPayload.Type<UpdateStorageItemsPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_storage_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateStorageItemsPacket> CODEC = StreamCodec.composite((StreamCodec)StoredItemStack.STREAM.apply(ByteBufCodecs.list()), u -> u.stacks, UpdateStorageItemsPacket::new);

    public UpdateStorageItemsPacket(List<StoredItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        super.onClientReceived(minecraft, player);
        Screen screen = minecraft.screen;
        if (screen instanceof AbstractStorageTerminalScreen) {
            AbstractStorageTerminalScreen terminalScreen = (AbstractStorageTerminalScreen)screen;
            terminalScreen.updateItems(this.stacks);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

