/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.util;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.analysis.CharArraySet;
import org.apache.lucene.ars_nouveau.analysis.TokenFilterFactory;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.ars_nouveau.analysis.util.ElisionFilter;
import org.apache.lucene.ars_nouveau.util.ResourceLoader;
import org.apache.lucene.ars_nouveau.util.ResourceLoaderAware;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "elision";
    private final String articlesFile;
    private final boolean ignoreCase;
    private CharArraySet articles;

    public ElisionFilterFactory(Map<String, String> args) {
        super(args);
        this.articlesFile = this.get(args, "articles");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public ElisionFilterFactory() {
        throw ElisionFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.articles = this.articlesFile == null ? FrenchAnalyzer.DEFAULT_ARTICLES : this.getWordSet(loader, this.articlesFile, this.ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

