/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.codecs.StoredFieldsReader;
import org.apache.lucene.ars_nouveau.document.StoredValue;
import org.apache.lucene.ars_nouveau.index.DocIDMerger;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.MergeState;
import org.apache.lucene.ars_nouveau.index.StoredFieldVisitor;
import org.apache.lucene.ars_nouveau.store.DataInput;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public abstract class StoredFieldsWriter
implements Closeable,
Accountable {
    protected StoredFieldsWriter() {
    }

    public abstract void startDocument() throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void writeField(FieldInfo var1, int var2) throws IOException;

    public abstract void writeField(FieldInfo var1, long var2) throws IOException;

    public abstract void writeField(FieldInfo var1, float var2) throws IOException;

    public abstract void writeField(FieldInfo var1, double var2) throws IOException;

    public void writeField(FieldInfo info, DataInput value, int length) throws IOException {
        byte[] bytes = new byte[length];
        value.readBytes(bytes, 0, length);
        this.writeField(info, new BytesRef(bytes, 0, length));
    }

    public abstract void writeField(FieldInfo var1, BytesRef var2) throws IOException;

    public abstract void writeField(FieldInfo var1, String var2) throws IOException;

    public abstract void finish(int var1) throws IOException;

    public int merge(MergeState mergeState) throws IOException {
        StoredFieldsMergeSub sub;
        ArrayList<StoredFieldsMergeSub> subs = new ArrayList<StoredFieldsMergeSub>();
        for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
            StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[i];
            storedFieldsReader.checkIntegrity();
            subs.add(new StoredFieldsMergeSub(new MergeVisitor(mergeState, i), mergeState.docMaps[i], storedFieldsReader, mergeState.maxDocs[i]));
        }
        DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
        int docCount = 0;
        while ((sub = (StoredFieldsMergeSub)docIDMerger.next()) != null) {
            assert (sub.mappedDocID == docCount);
            this.startDocument();
            sub.reader.document(sub.docID, sub.visitor);
            this.finishDocument();
            ++docCount;
        }
        this.finish(docCount);
        return docCount;
    }

    @Override
    public abstract void close() throws IOException;

    private static class StoredFieldsMergeSub
    extends DocIDMerger.Sub {
        private final StoredFieldsReader reader;
        private final int maxDoc;
        private final MergeVisitor visitor;
        int docID = -1;

        public StoredFieldsMergeSub(MergeVisitor visitor, MergeState.DocMap docMap, StoredFieldsReader reader, int maxDoc) {
            super(docMap);
            this.maxDoc = maxDoc;
            this.reader = reader;
            this.visitor = visitor;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }

    protected class MergeVisitor
    extends StoredFieldVisitor {
        StoredValue storedValue;
        FieldInfo currentField;
        FieldInfos remapper;

        public MergeVisitor(MergeState mergeState, int readerIndex) {
            for (FieldInfo fi : mergeState.fieldInfos[readerIndex]) {
                FieldInfo other = mergeState.mergeFieldInfos.fieldInfo(fi.number);
                if (other != null && other.name.equals(fi.name)) continue;
                this.remapper = mergeState.mergeFieldInfos;
                break;
            }
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, DataInput value, int length) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value, length);
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), new BytesRef(value));
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), Objects.requireNonNull(value, "String value should not be null"));
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        private FieldInfo remap(FieldInfo field) {
            if (this.remapper != null) {
                return this.remapper.fieldInfo(field.name);
            }
            return field;
        }
    }
}

