/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import org.apache.lucene.ars_nouveau.document.BinaryRangeDocValuesField;
import org.apache.lucene.ars_nouveau.document.FloatRange;
import org.apache.lucene.ars_nouveau.document.FloatRangeSlowRangeQuery;
import org.apache.lucene.ars_nouveau.document.RangeFieldQuery;
import org.apache.lucene.ars_nouveau.search.Query;

public class FloatRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final float[] min;
    final float[] max;

    public FloatRangeDocValuesField(String field, float[] min, float[] max) {
        super(field, FloatRange.encode(min, max), min.length, 4);
        FloatRangeDocValuesField.checkArgs(min, max);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public float getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public float getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, float[] min, float[] max, RangeFieldQuery.QueryType queryType) {
        FloatRangeDocValuesField.checkArgs(min, max);
        return new FloatRangeSlowRangeQuery(field, min, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, float[] min, float[] max) {
        return FloatRangeDocValuesField.newSlowRangeQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(float[] min, float[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min.length; ++i) {
            if (!(min[i] > max[i])) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

