/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.codecs.DocValuesFormat;
import org.apache.lucene.ars_nouveau.codecs.DocValuesProducer;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.SegmentCommitInfo;
import org.apache.lucene.ars_nouveau.index.SegmentReadState;
import org.apache.lucene.ars_nouveau.internal.hppc.LongArrayList;
import org.apache.lucene.ars_nouveau.internal.hppc.LongObjectHashMap;
import org.apache.lucene.ars_nouveau.store.Directory;
import org.apache.lucene.ars_nouveau.store.IOContext;
import org.apache.lucene.ars_nouveau.util.IOUtils;
import org.apache.lucene.ars_nouveau.util.RefCount;

final class SegmentDocValues {
    private final LongObjectHashMap<RefCount<DocValuesProducer>> genDVProducers = new LongObjectHashMap();

    SegmentDocValues() {
    }

    private RefCount<DocValuesProducer> newDocValuesProducer(SegmentCommitInfo si, Directory dir, final long gen, FieldInfos infos) throws IOException {
        Directory dvDir = dir;
        String segmentSuffix = "";
        if (gen != -1L) {
            dvDir = si.info.dir;
            segmentSuffix = Long.toString(gen, 36);
        }
        SegmentReadState srs = new SegmentReadState(dvDir, si.info, infos, IOContext.DEFAULT, segmentSuffix);
        DocValuesFormat dvFormat = si.info.getCodec().docValuesFormat();
        return new RefCount<DocValuesProducer>(dvFormat.fieldsProducer(srs)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void release() throws IOException {
                ((DocValuesProducer)this.object).close();
                SegmentDocValues segmentDocValues = SegmentDocValues.this;
                synchronized (segmentDocValues) {
                    SegmentDocValues.this.genDVProducers.remove(gen);
                }
            }
        };
    }

    synchronized DocValuesProducer getDocValuesProducer(long gen, SegmentCommitInfo si, Directory dir, FieldInfos infos) throws IOException {
        RefCount<DocValuesProducer> dvp = this.genDVProducers.get(gen);
        if (dvp == null) {
            dvp = this.newDocValuesProducer(si, dir, gen, infos);
            assert (dvp != null);
            this.genDVProducers.put(gen, dvp);
        } else {
            dvp.incRef();
        }
        return dvp.get();
    }

    synchronized void decRef(LongArrayList dvProducersGens) throws IOException {
        IOUtils.applyToAll(dvProducersGens.stream().mapToObj(Long::valueOf).toList(), gen -> {
            RefCount<DocValuesProducer> dvp = this.genDVProducers.get((long)gen);
            assert (dvp != null) : "gen=" + gen;
            dvp.decRef();
        });
    }
}

