/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatches;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalQuery;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;

class OffsetIntervalsSource
extends IntervalsSource {
    private final IntervalsSource in;
    private final boolean before;

    OffsetIntervalsSource(IntervalsSource in, boolean before) {
        this.in = in;
        this.before = before;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator it = this.in.intervals(field, ctx);
        if (it == null) {
            return null;
        }
        return this.offset(it);
    }

    private IntervalIterator offset(IntervalIterator it) {
        if (this.before) {
            return new OffsetIntervalIterator(this, it){

                @Override
                public int start() {
                    int pos = this.in.start();
                    if (pos == -1) {
                        return -1;
                    }
                    if (pos == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return Math.max(0, pos - 1);
                }
            };
        }
        return new OffsetIntervalIterator(this, it){

            @Override
            public int start() {
                int pos = this.in.end() + 1;
                if (pos == 0) {
                    return -1;
                }
                if (pos < 0) {
                    return Integer.MAX_VALUE;
                }
                if (pos == Integer.MAX_VALUE) {
                    return 0x7FFFFFFE;
                }
                return pos;
            }
        };
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        IntervalMatchesIterator mi = this.in.matches(field, ctx, doc);
        if (mi == null) {
            return null;
        }
        return IntervalMatches.asMatches(this.offset(IntervalMatches.wrapMatches(mi, doc)), mi, doc);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        this.in.visit(field, visitor.getSubVisitor(BooleanClause.Occur.MUST, new IntervalQuery(field, this)));
    }

    @Override
    public int minExtent() {
        return 1;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetIntervalsSource that = (OffsetIntervalsSource)o;
        return this.before == that.before && Objects.equals(this.in, that.in);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.before);
    }

    @Override
    public String toString() {
        if (this.before) {
            return "PRECEDING(" + String.valueOf(this.in) + ")";
        }
        return "FOLLOWING(" + String.valueOf(this.in) + ")";
    }

    private static abstract class OffsetIntervalIterator
    extends IntervalIterator {
        final IntervalIterator in;

        OffsetIntervalIterator(IntervalIterator in) {
            this.in = in;
        }

        @Override
        public int end() {
            return this.start();
        }

        @Override
        public int gaps() {
            return 0;
        }

        @Override
        public int nextInterval() throws IOException {
            this.in.nextInterval();
            return this.start();
        }

        @Override
        public float matchCost() {
            return this.in.matchCost();
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }

        @Override
        public long cost() {
            return this.in.cost();
        }
    }
}

