/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.index.TermStates;
import org.apache.lucene.ars_nouveau.queries.spans.FilterSpans;
import org.apache.lucene.ars_nouveau.queries.spans.SpanQuery;
import org.apache.lucene.ars_nouveau.queries.spans.SpanWeight;
import org.apache.lucene.ars_nouveau.queries.spans.Spans;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;

public final class SpanNotQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;
    private final int pre;
    private final int post;

    public SpanNotQuery(SpanQuery include, SpanQuery exclude) {
        this(include, exclude, 0, 0);
    }

    public SpanNotQuery(SpanQuery include, SpanQuery exclude, int dist) {
        this(include, exclude, dist, dist);
    }

    public SpanNotQuery(SpanQuery include, SpanQuery exclude, int pre, int post) {
        this.include = Objects.requireNonNull(include);
        this.exclude = Objects.requireNonNull(exclude);
        this.pre = pre;
        this.post = post;
        if (include.getField() != null && exclude.getField() != null && !include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    @Override
    public String getField() {
        return this.include.getField();
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNot(");
        buffer.append(this.include.toString(field));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field));
        buffer.append(", ");
        buffer.append(Integer.toString(this.pre));
        buffer.append(", ");
        buffer.append(Integer.toString(this.post));
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight includeWeight = this.include.createWeight(searcher, scoreMode, boost);
        SpanWeight excludeWeight = this.exclude.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
        return new SpanNotWeight(searcher, scoreMode.needsScores() ? SpanNotQuery.getTermStates(includeWeight) : null, includeWeight, excludeWeight, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        SpanQuery rewrittenInclude = (SpanQuery)this.include.rewrite(indexSearcher);
        SpanQuery rewrittenExclude = (SpanQuery)this.exclude.rewrite(indexSearcher);
        if (rewrittenInclude != this.include || rewrittenExclude != this.exclude) {
            return new SpanNotQuery(rewrittenInclude, rewrittenExclude, this.pre, this.post);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            this.include.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
            this.exclude.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST_NOT, this));
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanNotQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanNotQuery other) {
        return this.include.equals(other.include) && this.exclude.equals(other.exclude) && this.pre == other.pre && this.post == other.post;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = Integer.rotateLeft(h, 1);
        h ^= this.include.hashCode();
        h = Integer.rotateLeft(h, 1);
        h ^= this.exclude.hashCode();
        h = Integer.rotateLeft(h, 1);
        h ^= this.pre;
        h = Integer.rotateLeft(h, 1);
        return h ^= this.post;
    }

    public class SpanNotWeight
    extends SpanWeight {
        final SpanWeight includeWeight;
        final SpanWeight excludeWeight;

        public SpanNotWeight(IndexSearcher searcher, Map<Term, TermStates> terms, SpanWeight includeWeight, SpanWeight excludeWeight, float boost) throws IOException {
            super(SpanNotQuery.this, searcher, terms, boost);
            this.includeWeight = includeWeight;
            this.excludeWeight = excludeWeight;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            this.includeWeight.extractTermStates(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Spans includeSpans = this.includeWeight.getSpans(context, requiredPostings);
            if (includeSpans == null) {
                return null;
            }
            final Spans excludeSpans = this.excludeWeight.getSpans(context, requiredPostings);
            if (excludeSpans == null) {
                return includeSpans;
            }
            final TwoPhaseIterator excludeTwoPhase = excludeSpans.asTwoPhaseIterator();
            final DocIdSetIterator excludeApproximation = excludeTwoPhase == null ? null : excludeTwoPhase.approximation();
            return new FilterSpans(includeSpans){
                int lastApproxDoc;
                boolean lastApproxResult;
                {
                    super(in);
                    this.lastApproxDoc = -1;
                    this.lastApproxResult = false;
                }

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    int doc = candidate.docID();
                    if (doc > excludeSpans.docID()) {
                        if (excludeTwoPhase != null) {
                            if (excludeApproximation.advance(doc) == doc) {
                                this.lastApproxDoc = doc;
                                this.lastApproxResult = excludeTwoPhase.matches();
                            }
                        } else {
                            excludeSpans.advance(doc);
                        }
                    } else if (excludeTwoPhase != null && doc == excludeSpans.docID() && doc != this.lastApproxDoc) {
                        this.lastApproxDoc = doc;
                        this.lastApproxResult = excludeTwoPhase.matches();
                    }
                    if (doc != excludeSpans.docID() || doc == this.lastApproxDoc && !this.lastApproxResult) {
                        return FilterSpans.AcceptStatus.YES;
                    }
                    if (excludeSpans.startPosition() == -1) {
                        excludeSpans.nextStartPosition();
                    }
                    while (excludeSpans.endPosition() <= candidate.startPosition() - SpanNotQuery.this.pre) {
                        if (excludeSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                        return FilterSpans.AcceptStatus.YES;
                    }
                    if (excludeSpans.startPosition() - SpanNotQuery.this.post >= candidate.endPosition()) {
                        return FilterSpans.AcceptStatus.YES;
                    }
                    return FilterSpans.AcceptStatus.NO;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.includeWeight.isCacheable(ctx) && this.excludeWeight.isCacheable(ctx);
        }
    }
}

