/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.search;

import guideme.PageCollection;
import guideme.compiler.IndexingContext;
import guideme.compiler.IndexingSink;
import guideme.compiler.TagCompiler;
import guideme.extensions.Extension;
import guideme.extensions.ExtensionCollection;
import guideme.extensions.ExtensionPoint;
import guideme.libs.mdast.MdAstYamlFrontmatter;
import guideme.libs.mdast.gfm.model.GfmTable;
import guideme.libs.mdast.gfm.model.GfmTableCell;
import guideme.libs.mdast.gfm.model.GfmTableRow;
import guideme.libs.mdast.gfmstrikethrough.MdAstDelete;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.libs.mdast.model.MdAstBlockquote;
import guideme.libs.mdast.model.MdAstBreak;
import guideme.libs.mdast.model.MdAstCode;
import guideme.libs.mdast.model.MdAstEmphasis;
import guideme.libs.mdast.model.MdAstHeading;
import guideme.libs.mdast.model.MdAstImage;
import guideme.libs.mdast.model.MdAstInlineCode;
import guideme.libs.mdast.model.MdAstLink;
import guideme.libs.mdast.model.MdAstList;
import guideme.libs.mdast.model.MdAstListContent;
import guideme.libs.mdast.model.MdAstListItem;
import guideme.libs.mdast.model.MdAstParagraph;
import guideme.libs.mdast.model.MdAstRoot;
import guideme.libs.mdast.model.MdAstStrong;
import guideme.libs.mdast.model.MdAstText;
import guideme.libs.mdast.model.MdAstThematicBreak;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageIndexer
implements IndexingContext {
    private static final Logger LOG = LoggerFactory.getLogger(PageIndexer.class);
    private final PageCollection pages;
    private final ExtensionCollection extensions;
    private final ResourceLocation pageId;
    private final Map<String, TagCompiler> tagCompilers = new HashMap<String, TagCompiler>();

    public PageIndexer(PageCollection pages, ExtensionCollection extensions, ResourceLocation pageId) {
        this.pages = pages;
        this.extensions = extensions;
        this.pageId = pageId;
        for (TagCompiler tagCompiler : extensions.get(TagCompiler.EXTENSION_POINT)) {
            for (String tagName : tagCompiler.getTagNames()) {
                this.tagCompilers.put(tagName, tagCompiler);
            }
        }
    }

    @Override
    public ExtensionCollection getExtensions() {
        return this.extensions;
    }

    @Override
    public <T extends Extension> List<T> getExtensions(ExtensionPoint<T> extensionPoint) {
        return this.extensions.get(extensionPoint);
    }

    public void index(MdAstRoot root, IndexingSink sink) {
        this.indexContent(root.children(), sink);
    }

    @Override
    public void indexContent(MdAstAnyContent content, IndexingSink sink) {
        if (content instanceof MdAstThematicBreak) {
            sink.appendBreak();
        } else if (content instanceof MdAstList) {
            MdAstList astList = (MdAstList)content;
            this.indexList(astList, sink);
        } else if (content instanceof MdAstCode) {
            MdAstCode astCode = (MdAstCode)content;
            sink.appendText(astCode, astCode.value);
        } else if (content instanceof MdAstHeading) {
            MdAstHeading astHeading = (MdAstHeading)content;
            this.indexContent(astHeading.children(), sink);
        } else if (content instanceof MdAstBlockquote) {
            MdAstBlockquote astBlockquote = (MdAstBlockquote)content;
            this.indexContent(astBlockquote.children(), sink);
        } else if (content instanceof MdAstParagraph) {
            MdAstParagraph astParagraph = (MdAstParagraph)content;
            this.indexContent(astParagraph.children(), sink);
        } else if (!(content instanceof MdAstYamlFrontmatter)) {
            if (content instanceof GfmTable) {
                GfmTable astTable = (GfmTable)content;
                this.indexTable(astTable, sink);
            } else if (content instanceof MdAstText) {
                MdAstText astText = (MdAstText)content;
                sink.appendText(astText, astText.value);
            } else if (content instanceof MdAstInlineCode) {
                MdAstInlineCode astCode = (MdAstInlineCode)content;
                sink.appendText(astCode, astCode.value);
            } else if (content instanceof MdAstStrong) {
                MdAstStrong astStrong = (MdAstStrong)content;
                this.indexContent(astStrong.children(), sink);
            } else if (content instanceof MdAstEmphasis) {
                MdAstEmphasis astEmphasis = (MdAstEmphasis)content;
                this.indexContent(astEmphasis.children(), sink);
            } else if (content instanceof MdAstDelete) {
                MdAstDelete astDelete = (MdAstDelete)content;
                this.indexContent(astDelete.children(), sink);
            } else if (content instanceof MdAstBreak) {
                sink.appendBreak();
            } else if (content instanceof MdAstLink) {
                MdAstLink astLink = (MdAstLink)content;
                this.indexLink(astLink, sink);
            } else if (content instanceof MdAstImage) {
                MdAstImage astImage = (MdAstImage)content;
                this.indexImage(astImage, sink);
            } else if (content instanceof MdxJsxElementFields) {
                MdxJsxElementFields el = (MdxJsxElementFields)((Object)content);
                TagCompiler compiler = this.tagCompilers.get(el.name());
                if (compiler == null) {
                    LOG.warn("Unhandled custom MDX element in guide search indexing: {}", (Object)el.name());
                } else {
                    compiler.index(this, el, sink);
                }
            } else {
                LOG.warn("Unhandled node type in guide search indexing: {}", (Object)content.type());
            }
        }
        sink.appendBreak();
    }

    private void indexList(MdAstList astList, IndexingSink sink) {
        for (MdAstListContent listContent : astList.children()) {
            if (listContent instanceof MdAstListItem) {
                MdAstListItem astListItem = (MdAstListItem)listContent;
                this.indexContent(astListItem.children(), sink);
                continue;
            }
            LOG.warn("Cannot handle list content: {}", (Object)listContent);
        }
    }

    private void indexTable(GfmTable astTable, IndexingSink sink) {
        for (GfmTableRow astRow : astTable.children()) {
            List astCells = astRow.children();
            for (GfmTableCell astCell : astCells) {
                this.indexContent(astCell.children(), sink);
            }
        }
    }

    private void indexLink(MdAstLink astLink, IndexingSink sink) {
        if (astLink.title != null && !astLink.title.isEmpty()) {
            sink.appendText(astLink, astLink.title);
        }
        this.indexContent(astLink.children(), sink);
    }

    private void indexImage(MdAstImage astImage, IndexingSink sink) {
        if (astImage.title != null && !astImage.title.isEmpty()) {
            sink.appendText(astImage, astImage.title);
        }
        if (astImage.alt != null && !astImage.alt.isEmpty()) {
            sink.appendText(astImage, astImage.alt);
        }
    }

    @Override
    public ResourceLocation getPageId() {
        return this.pageId;
    }

    @Override
    public PageCollection getPageCollection() {
        return this.pages;
    }
}

