/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.cjk;

import guideme.internal.shaded.lucene.analysis.charfilter.BaseCharFilter;
import java.io.IOException;
import java.io.Reader;

public class CJKWidthCharFilter
extends BaseCharFilter {
    private static final char[] KANA_NORM = new char[]{'\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u3099', '\u309a'};
    private static final byte[] KANA_COMBINE_VOICED = new byte[]{78, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] KANA_COMBINE_SEMI_VOICED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int HW_KATAKANA_VOICED_MARK = 65438;
    private static final int HW_KATAKANA_SEMI_VOICED_MARK = 65439;
    private int prevChar = -1;
    private int inputOff = 0;

    public CJKWidthCharFilter(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int ret;
        do {
            int combinedChar;
            int ch;
            if ((ch = this.input.read()) == -1) {
                ret = this.prevChar;
                this.prevChar = ch;
                return ret;
            }
            ++this.inputOff;
            ret = -1;
            if ((ch == 65439 || ch == 65438) && this.prevChar != (combinedChar = this.combineVoiceMark(this.prevChar, ch))) {
                this.prevChar = -1;
                int prevCumulativeDiff = this.getLastCumulativeDiff();
                this.addOffCorrectMap(this.inputOff - 1 - prevCumulativeDiff, prevCumulativeDiff + 1);
                return combinedChar;
            }
            if (this.prevChar != -1) {
                ret = this.prevChar;
            }
            this.prevChar = ch >= 65281 && ch <= 65374 ? ch - 65248 : (ch >= 65381 && ch <= 65439 ? KANA_NORM[ch - 65381] : ch);
        } while (ret == -1);
        return ret;
    }

    private int combineVoiceMark(int ch, int voiceMark) {
        assert (voiceMark == 65439 || voiceMark == 65438);
        if (ch >= 12454 && ch <= 12541) {
            ch += voiceMark == 65439 ? KANA_COMBINE_SEMI_VOICED[this.prevChar - 12454] : KANA_COMBINE_VOICED[this.prevChar - 12454];
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int numRead = 0;
        for (int i = off; i < off + len && (c = this.read()) != -1; ++i) {
            cbuf[i] = (char)c;
            ++numRead;
        }
        return numRead == 0 ? -1 : numRead;
    }
}

