/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.morph;

import guideme.internal.shaded.lucene.analysis.morph.Dictionary;
import guideme.internal.shaded.lucene.analysis.morph.MorphData;
import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.InputStreamDataInput;
import guideme.internal.shaded.lucene.util.IOSupplier;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public abstract class BinaryDictionary<T extends MorphData>
implements Dictionary<T> {
    public static final String DICT_FILENAME_SUFFIX = "$buffer.dat";
    public static final String TARGETMAP_FILENAME_SUFFIX = "$targetMap.dat";
    public static final String POSDICT_FILENAME_SUFFIX = "$posDict.dat";
    private final int[] targetMapOffsets;
    private final int[] targetMap;
    protected final ByteBuffer buffer;

    protected BinaryDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> dictResource, String targetMapCodecHeader, String dictCodecHeader, int dictCodecVersion) throws IOException {
        InputStreamDataInput in;
        try (BufferedInputStream mapIS = new BufferedInputStream(targetMapResource.get());){
            in = new InputStreamDataInput(mapIS);
            CodecUtil.checkHeader(in, targetMapCodecHeader, dictCodecVersion, dictCodecVersion);
            this.targetMap = new int[in.readVInt()];
            this.targetMapOffsets = new int[in.readVInt()];
            BinaryDictionary.populateTargetMap(in, this.targetMap, this.targetMapOffsets);
        }
        try (InputStream dictIS = dictResource.get();){
            in = new InputStreamDataInput(dictIS);
            CodecUtil.checkHeader(in, dictCodecHeader, dictCodecVersion, dictCodecVersion);
            int size = in.readVInt();
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
            ReadableByteChannel channel = Channels.newChannel(dictIS);
            int read = channel.read(tmpBuffer);
            if (read != size) {
                throw new EOFException("Cannot read whole dictionary");
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
    }

    private static void populateTargetMap(DataInput in, int[] targetMap, int[] targetMapOffsets) throws IOException {
        int accum = 0;
        int sourceId = 0;
        for (int ofs = 0; ofs < targetMap.length; ++ofs) {
            int val = in.readVInt();
            if ((val & 1) != 0) {
                targetMapOffsets[sourceId] = ofs;
                ++sourceId;
            }
            targetMap[ofs] = accum += val >>> 1;
        }
        if (sourceId + 1 != targetMapOffsets.length) {
            throw new IOException("targetMap file format broken; targetMap.length=" + targetMap.length + ", targetMapOffsets.length=" + targetMapOffsets.length + ", sourceId=" + sourceId);
        }
        targetMapOffsets[sourceId] = targetMap.length;
    }

    public void lookupWordIds(int sourceId, IntsRef ref) {
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[sourceId + 1] - ref.offset;
    }
}

