/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.taxonomy.OrdinalMappingLeafReader;
import guideme.internal.shaded.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import guideme.internal.shaded.lucene.index.CodecReader;
import guideme.internal.shaded.lucene.index.DirectoryReader;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.SlowCodecReaderWrapper;
import guideme.internal.shaded.lucene.store.Directory;
import java.io.IOException;
import java.util.List;

public abstract class TaxonomyMergeUtils {
    private TaxonomyMergeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Directory srcIndexDir, Directory srcTaxoDir, DirectoryTaxonomyWriter.OrdinalMap map, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxoWriter, FacetsConfig srcConfig) throws IOException {
        destTaxoWriter.addTaxonomy(srcTaxoDir, map);
        int[] ordinalMap = map.getMap();
        try (DirectoryReader reader = DirectoryReader.open(srcIndexDir);){
            List<LeafReaderContext> leaves = reader.leaves();
            int numReaders = leaves.size();
            CodecReader[] wrappedLeaves = new CodecReader[numReaders];
            for (int i = 0; i < numReaders; ++i) {
                wrappedLeaves[i] = SlowCodecReaderWrapper.wrap(new OrdinalMappingLeafReader(leaves.get(i).reader(), ordinalMap, srcConfig));
            }
            destIndexWriter.addIndexes(wrappedLeaves);
            destTaxoWriter.commit();
            destIndexWriter.commit();
        }
    }
}

