/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.highlight;

import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.search.highlight.Fragmenter;
import guideme.internal.shaded.lucene.search.highlight.PositionSpan;
import guideme.internal.shaded.lucene.search.highlight.QueryScorer;
import guideme.internal.shaded.lucene.search.highlight.WeightedSpanTerm;
import java.util.List;

public class SimpleSpanFragmenter
implements Fragmenter {
    private static final int DEFAULT_FRAGMENT_SIZE = 100;
    private int fragmentSize;
    private int currentNumFrags;
    private int position = -1;
    private QueryScorer queryScorer;
    private int waitForPos = -1;
    private int textSize;
    private CharTermAttribute termAtt;
    private PositionIncrementAttribute posIncAtt;
    private OffsetAttribute offsetAtt;

    public SimpleSpanFragmenter(QueryScorer queryScorer) {
        this(queryScorer, 100);
    }

    public SimpleSpanFragmenter(QueryScorer queryScorer, int fragmentSize) {
        this.fragmentSize = fragmentSize;
        this.queryScorer = queryScorer;
    }

    @Override
    public boolean isNewFragment() {
        boolean isNewFrag;
        this.position += this.posIncAtt.getPositionIncrement();
        if (this.waitForPos <= this.position) {
            this.waitForPos = -1;
        } else if (this.waitForPos != -1) {
            return false;
        }
        WeightedSpanTerm wSpanTerm = this.queryScorer.getWeightedSpanTerm(this.termAtt.toString());
        if (wSpanTerm != null) {
            List<PositionSpan> positionSpans = wSpanTerm.getPositionSpans();
            for (PositionSpan positionSpan : positionSpans) {
                if (positionSpan.start != this.position) continue;
                this.waitForPos = positionSpan.end + 1;
                break;
            }
        }
        boolean bl = isNewFrag = this.offsetAtt.endOffset() >= this.fragmentSize * this.currentNumFrags && this.textSize - this.offsetAtt.endOffset() >= this.fragmentSize >>> 1;
        if (isNewFrag) {
            ++this.currentNumFrags;
        }
        return isNewFrag;
    }

    @Override
    public void start(String originalText, TokenStream tokenStream) {
        this.position = -1;
        this.currentNumFrags = 1;
        this.textSize = originalText.length();
        this.termAtt = tokenStream.addAttribute(CharTermAttribute.class);
        this.posIncAtt = tokenStream.addAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = tokenStream.addAttribute(OffsetAttribute.class);
    }
}

