/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphBuilder;
import guideme.internal.shaded.lucene.util.hnsw.NeighborArray;
import guideme.internal.shaded.lucene.util.hnsw.OnHeapHnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public final class InitializedHnswGraphBuilder
extends HnswGraphBuilder {
    private final BitSet initializedNodes;

    public static InitializedHnswGraphBuilder fromGraph(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, HnswGraph initializerGraph, int[] newOrdMap, BitSet initializedNodes, int totalNumberOfVectors) throws IOException {
        return new InitializedHnswGraphBuilder(scorerSupplier, M, beamWidth, seed, InitializedHnswGraphBuilder.initGraph(M, initializerGraph, newOrdMap, totalNumberOfVectors), initializedNodes);
    }

    public static OnHeapHnswGraph initGraph(int M, HnswGraph initializerGraph, int[] newOrdMap, int totalNumberOfVectors) throws IOException {
        OnHeapHnswGraph hnsw = new OnHeapHnswGraph(M, totalNumberOfVectors);
        for (int level = initializerGraph.numLevels() - 1; level >= 0; --level) {
            HnswGraph.NodesIterator it = initializerGraph.getNodesOnLevel(level);
            while (it.hasNext()) {
                int oldOrd = it.nextInt();
                int newOrd = newOrdMap[oldOrd];
                hnsw.addNode(level, newOrd);
                hnsw.trySetNewEntryNode(newOrd, level);
                NeighborArray newNeighbors = hnsw.getNeighbors(level, newOrd);
                initializerGraph.seek(level, oldOrd);
                int oldNeighbor = initializerGraph.nextNeighbor();
                while (oldNeighbor != Integer.MAX_VALUE) {
                    int newNeighbor = newOrdMap[oldNeighbor];
                    newNeighbors.addOutOfOrder(newNeighbor, Float.NaN);
                    oldNeighbor = initializerGraph.nextNeighbor();
                }
            }
        }
        return hnsw;
    }

    public InitializedHnswGraphBuilder(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, OnHeapHnswGraph initializedGraph, BitSet initializedNodes) throws IOException {
        super(scorerSupplier, M, beamWidth, seed, initializedGraph);
        this.initializedNodes = initializedNodes;
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        if (this.initializedNodes.get(node)) {
            return;
        }
        super.addGraphNode(node);
    }
}

