/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Subtokenize {
    private Subtokenize() {
    }

    public static boolean subtokenize(List<Tokenizer.Event> events) {
        HashMap<Integer, Integer> jumps = new HashMap<Integer, Integer>();
        int index = -1;
        boolean more = false;
        while (++index < events.size()) {
            int otherIndex;
            while (jumps.containsKey(index)) {
                index = (Integer)jumps.get(index);
            }
            Tokenizer.Event event = events.get(index);
            if (index != 0 && event.token().type.equals("chunkFlow") && events.get((int)(index - 1)).token().type.equals("listItemPrefix")) {
                Assert.check(event.token()._tokenizer != null, "expected '_tokenizer' on subtokens");
                List<Tokenizer.Event> subevents = event.token()._tokenizer.getEvents();
                otherIndex = 0;
                if (otherIndex < subevents.size() && subevents.get((int)otherIndex).token().type.equals("lineEndingBlank")) {
                    otherIndex += 2;
                }
                if (otherIndex < subevents.size() && subevents.get((int)otherIndex).token().type.equals("content")) {
                    while (++otherIndex < subevents.size() && !subevents.get((int)otherIndex).token().type.equals("content")) {
                        if (!subevents.get((int)otherIndex).token().type.equals("chunkText")) continue;
                        subevents.get((int)otherIndex).token()._isInFirstContentOfListItem = true;
                        ++otherIndex;
                    }
                }
            }
            if (event.isEnter()) {
                if (event.token().contentType == null) continue;
                jumps.putAll(Subtokenize.subcontent(events, index));
                index = (Integer)jumps.get(index);
                more = true;
                continue;
            }
            if (!event.token()._container) continue;
            otherIndex = index;
            Integer lineIndex = null;
            while (otherIndex-- != 0) {
                Tokenizer.Event otherEvent = events.get(otherIndex);
                if (!otherEvent.token().type.equals("lineEnding") && !otherEvent.token().type.equals("lineEndingBlank")) break;
                if (!otherEvent.isEnter()) continue;
                if (lineIndex != null) {
                    events.get((int)lineIndex.intValue()).token().type = "lineEndingBlank";
                }
                otherEvent.token().type = "lineEnding";
                lineIndex = otherIndex;
            }
            if (lineIndex == null) continue;
            event.token().end = events.get((int)lineIndex.intValue()).token().start;
            List<Tokenizer.Event> parameters = ListUtils.slice(events, lineIndex, index);
            parameters.add(0, event);
            ListUtils.splice(events, lineIndex, index - lineIndex + 1, parameters);
        }
        return !more;
    }

    private static Map<Integer, Integer> subcontent(List<Tokenizer.Event> events, int eventIndex) {
        Token token = events.get(eventIndex).token();
        TokenizeContext context = events.get(eventIndex).context();
        int startPosition = eventIndex - 1;
        ArrayList<Integer> startPositions = new ArrayList<Integer>();
        Assert.check(token.contentType != null, "expected 'contentType' on subtokens");
        TokenizeContext tokenizer = Objects.requireNonNullElse(token._tokenizer, context.getParser().get(token.contentType).create(token.start));
        List<Tokenizer.Event> childEvents = tokenizer.getEvents();
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        HashMap<Integer, Integer> gaps = new HashMap<Integer, Integer>();
        Token previous = null;
        int index = -1;
        Token current = token;
        int adjust = 0;
        ArrayList<Integer> breaks = new ArrayList<Integer>();
        breaks.add(0);
        while (current != null) {
            while (events.get(++startPosition).token() != current) {
            }
            Assert.check(previous == null || current.previous == previous, "expected previous to match");
            Assert.check(previous == null || previous.next == current, "expected next to match");
            startPositions.add(startPosition);
            if (current._tokenizer == null) {
                List<Object> stream = context.sliceStream(current);
                if (current.next == null) {
                    stream.add(Integer.MIN_VALUE);
                }
                if (previous != null) {
                    tokenizer.defineSkip(current.start);
                }
                if (current._isInFirstContentOfListItem) {
                    tokenizer.setGfmTasklistFirstContentOfListItem(true);
                }
                tokenizer.write(stream);
                if (current._isInFirstContentOfListItem) {
                    tokenizer.setGfmTasklistFirstContentOfListItem(false);
                }
            }
            previous = current;
            current = current.next;
        }
        current = token;
        while (++index < childEvents.size()) {
            Tokenizer.Event childEvent = childEvents.get(index);
            if (!childEvent.isExit() || !childEvents.get(index - 1).isEnter() || !childEvent.token().type.equals(childEvents.get((int)(index - 1)).token().type) || childEvent.token().start.line() == childEvent.token().end.line()) continue;
            Assert.check(current != null, "expected a current token");
            breaks.add(index + 1);
            current._tokenizer = null;
            current.previous = null;
            current = current.next;
        }
        childEvents = new ArrayList<Tokenizer.Event>(childEvents);
        tokenizer.getEvents().clear();
        if (current != null) {
            current._tokenizer = null;
            current.previous = null;
            Assert.check(current.next == null, "expected no next token");
        } else {
            breaks.remove(breaks.size() - 1);
        }
        index = breaks.size();
        while (index-- != 0) {
            List<Tokenizer.Event> slice = index + 1 < breaks.size() ? ListUtils.slice(childEvents, (Integer)breaks.get(index), (Integer)breaks.get(index + 1)) : ListUtils.slice(childEvents, (Integer)breaks.get(index));
            Integer start = (Integer)startPositions.remove(startPositions.size() - 1);
            Assert.check(start != null, "expected a start position when splicing");
            jumps.add(0, new Jump(start, start + slice.size() - 1));
            ListUtils.splice(events, start, 2, slice);
        }
        index = -1;
        while (++index < jumps.size()) {
            Jump jump = (Jump)jumps.get(index);
            gaps.put(adjust + jump.first(), adjust + jump.second());
            adjust += jump.second() - jump.first() - 1;
        }
        return gaps;
    }

    record Jump(int first, int second) {
    }
}

