/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters;

import com.google.common.collect.Sets;
import com.matyrobbrt.mekanisticrouters.MekRouters;
import com.matyrobbrt.mekanisticrouters.mixin.FilterAccess;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.api.matching.IModuleFlags;
import me.desht.modularrouters.logic.filter.Filter;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public record ChemicalFilter(Chemical chemical) implements IItemMatcher
{
    public ChemicalFilter(ItemStack stack) {
        this(MekRouters.getStoredChemical(stack).map(ChemicalStack::getChemical).orElse(ChemicalStack.EMPTY.getChemical()));
    }

    public boolean matchItem(ItemStack stack, IModuleFlags flags) {
        return MekRouters.getStoredChemical(stack).map(ch -> this.matchChemical(ch.getChemical(), flags)).orElse(false);
    }

    public boolean matchChemical(Chemical chemical, IModuleFlags flags) {
        return chemical == this.chemical || flags.matchItemTags() && !Sets.intersection(ChemicalFilter.chemicalTags(chemical), ChemicalFilter.chemicalTags(this.chemical)).isEmpty();
    }

    public static Set<TagKey<Chemical>> chemicalTags(Chemical chemical) {
        return MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chemical).tags().collect(Collectors.toSet());
    }

    public static boolean testFilter(Filter filter, ChemicalStack stack) {
        FilterAccess access = (FilterAccess)filter;
        for (IItemMatcher matcher : access.mekrouters$getMatchers()) {
            ChemicalFilter cf;
            if (!(matcher instanceof ChemicalFilter) || !(cf = (ChemicalFilter)matcher).matchChemical(stack.getChemical(), (IModuleFlags)access.mekrouters$getFlags())) continue;
            return access.mekrouters$getFlags().whiteList();
        }
        return !access.mekrouters$getFlags().whiteList();
    }
}

