/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mekanisticrouters.item;

import com.matyrobbrt.mekanisticrouters.ChemicalFilter;
import com.matyrobbrt.mekanisticrouters.MRConfig;
import com.matyrobbrt.mekanisticrouters.MekRouters;
import com.matyrobbrt.mekanisticrouters.item.ChemicalSettings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.settings.TransferDirection;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChemicalModule1
extends ModuleItem {
    private static final TintColor TINT_COLOR = new TintColor(219, 149, 249);

    public ChemicalModule1(Item.Properties properties) {
        super(properties, Compiled::new);
    }

    public String getRegulatorTranslationKey(ItemStack stack) {
        boolean isAbsolute = ((ChemicalSettings)stack.getOrDefault(MekRouters.CHEMICAL_SETTINGS, (Object)ChemicalSettings.DEFAULT)).regulateAbsolute();
        return "modularrouters.guiText.tooltip.regulator." + (isAbsolute ? "labelFluidmB" : "labelFluidPct");
    }

    public MenuType<? extends ModuleMenu> getMenuType() {
        return (MenuType)MekRouters.CHEMICAL_MODULE_MENU.get();
    }

    protected Component getFilterItemDisplayName(ItemStack stack) {
        return MekRouters.getStoredChemical(stack).map(ChemicalStack::getTextComponent).orElse(stack.getHoverName());
    }

    protected void addExtraInformation(ItemStack stack, List<Component> list) {
        super.addExtraInformation(stack, list);
        ChemicalSettings set = (ChemicalSettings)stack.getOrDefault(MekRouters.CHEMICAL_SETTINGS, (Object)ChemicalSettings.DEFAULT);
        list.add((Component)ClientUtil.xlate((String)"modularrouters.itemText.transfer_direction", (Object[])new Object[]{ClientUtil.xlate((String)set.direction().getTranslationKey(), (Object[])new Object[0]).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.YELLOW));
        list.add((Component)ClientUtil.xlate((String)"mekanisticrouters.itemText.chemical.maxTransfer", (Object[])new Object[]{ClientUtil.colorText((Object)set.maxTransfer(), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.AQUA})}).withStyle(ChatFormatting.YELLOW));
    }

    public int getEnergyCost(ItemStack stack) {
        return MRConfig.CHEMICAL_MODULE_1FE.getAsInt();
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        if (stack.isEmpty() || stack.getItem() instanceof SmartFilterItem) {
            return true;
        }
        if (stack.getCount() > 1) {
            return false;
        }
        return MekRouters.getStoredChemical(stack).map(cs -> !cs.isEmpty()).orElse(false);
    }

    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new ChemicalFilter(stack);
    }

    public boolean isFluidModule() {
        return true;
    }

    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    public static int getRouterMaxTransfer(ModularRouterBlockEntity router) {
        return MRConfig.BASE_CHEMICAL_RATE.getAsInt() + router.getUpgradeCount((UpgradeItem)MekRouters.CHEMICAL_UPGRADE.get()) * MRConfig.CHEMICAL_UPGRADE_MB.getAsInt();
    }

    public static class Compiled
    extends CompiledModule {
        private final ChemicalSettings settings;

        public Compiled(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
            super(router, stack);
            this.settings = (ChemicalSettings)stack.getOrDefault(MekRouters.CHEMICAL_SETTINGS, (Object)ChemicalSettings.DEFAULT);
        }

        public boolean execute(@Nonnull ModularRouterBlockEntity router) {
            if (this.getTarget() == null) {
                return false;
            }
            IChemicalHandler routerHandler = (IChemicalHandler)router.getBufferCapability(MekRouters.ITEM_CHEMICAL);
            if (routerHandler == null) {
                return false;
            }
            Level world = Objects.requireNonNull(router.getLevel());
            Optional<IChemicalHandler> targetChemicalHandler = Optional.ofNullable((IChemicalHandler)world.getCapability(MekRouters.BLOCK_CHEMICAL, this.getTarget().gPos.pos(), (Object)this.getTarget().face));
            if (targetChemicalHandler.isPresent()) {
                return switch (this.getTransferDirection()) {
                    default -> throw new MatchException(null, null);
                    case TransferDirection.TO_ROUTER -> targetChemicalHandler.map(worldHandler -> this.doTransfer(router, (IChemicalHandler)worldHandler, routerHandler, TransferDirection.TO_ROUTER)).orElse(false);
                    case TransferDirection.FROM_ROUTER -> targetChemicalHandler.map(worldHandler -> this.doTransfer(router, routerHandler, (IChemicalHandler)worldHandler, TransferDirection.FROM_ROUTER)).orElse(false);
                };
            }
            return false;
        }

        private boolean doTransfer(ModularRouterBlockEntity router, IChemicalHandler src, IChemicalHandler dest, TransferDirection direction) {
            int amount;
            ChemicalStack newStack;
            if (this.getRegulationAmount() > 0) {
                if (direction == TransferDirection.TO_ROUTER && this.checkChemicalInTank(src) <= (long)this.getRegulationAmount()) {
                    return false;
                }
                if (direction == TransferDirection.FROM_ROUTER && this.checkChemicalInTank(dest) >= (long)this.getRegulationAmount()) {
                    return false;
                }
            }
            if ((newStack = MekRouters.tryChemicalTransfer(src, dest, amount = this.getMaxTransfer(router), false)).isRadioactive() && !MRConfig.RADIATION_TRANSFER.getAsBoolean()) {
                return false;
            }
            if (!newStack.isEmpty() && ChemicalFilter.testFilter(this.getFilter(), newStack)) {
                return !(newStack = MekRouters.tryChemicalTransfer(src, dest, newStack.getAmount(), true)).isEmpty();
            }
            return false;
        }

        public int getMaxTransfer(ModularRouterBlockEntity router) {
            return this.settings.getEffectiveMaxTransfer(ChemicalModule1.getRouterMaxTransfer(router));
        }

        public boolean isRegulateAbsolute() {
            return this.settings.regulateAbsolute();
        }

        public TransferDirection getTransferDirection() {
            return this.settings.direction();
        }

        private long checkChemicalInTank(IChemicalHandler handler) {
            long total = 0L;
            long max = 0L;
            if (this.isRegulateAbsolute()) {
                for (int idx = 0; idx < handler.getChemicalTanks(); ++idx) {
                    total += handler.getChemicalInTank(idx).getAmount();
                }
                return total;
            }
            for (int idx = 0; idx < handler.getChemicalTanks(); ++idx) {
                max += handler.getChemicalTankCapacity(idx);
                total += handler.getChemicalInTank(idx).getAmount();
            }
            return max == 0L ? 0L : total * 100L / max;
        }
    }
}

