/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.AmountChangedEntry;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactantStackData
extends AbstractData<ReactantStack>
implements IContainerData {
    private ReactantStack _lastValue;
    private IBindableData<Integer> _amountData;

    public static ReactantStackData immutable(ModContainer container, ReactantStack value) {
        return ReactantStackData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static ReactantStackData empty(ModContainer container) {
        return ReactantStackData.immutable(container, ReactantStack.EMPTY);
    }

    public static ReactantStackData sampled(int frequency, ModContainer container, Supplier<@NotNull ReactantStack> getter, Consumer<@NotNull ReactantStack> clientSideSetter) {
        return ReactantStackData.of(container, (Supplier<ReactantStack>)new Sampler(frequency, getter), clientSideSetter);
    }

    public static ReactantStackData sampled(int frequency, ModContainer container, Supplier<@NotNull ReactantStack> getter) {
        return ReactantStackData.of(container, (Supplier<ReactantStack>)new Sampler(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static ReactantStackData of(ModContainer container, Supplier<@NotNull ReactantStack> getter, Consumer<@NotNull ReactantStack> clientSideSetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        ReactantStackData data = container.isClientSide() ? new ReactantStackData(getter, clientSideSetter) : new ReactantStackData(getter);
        container.addBindableData((IBindableData)data);
        return data;
    }

    public static ReactantStackData of(ModContainer container, Supplier<@NotNull ReactantStack> getter) {
        return ReactantStackData.of(container, getter, CodeHelper.emptyConsumer());
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.as((Object)0, intConsumer -> this.bind(stack -> intConsumer.accept(stack.getAmount())));
        }
        return this._amountData;
    }

    @Nullable
    public ISyncedSetEntry getChangedValue() {
        ReactantStack current = (ReactantStack)this.getValue();
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalReactant = this._lastValue.isReactantEqual(current);
        if (!equalReactant || current.getAmount() != this._lastValue.getAmount()) {
            this._lastValue = current;
            if (equalReactant) {
                return new AmountChangedEntry(this._lastValue.getAmount());
            }
            return new ReactantStackEntry(this._lastValue);
        }
        return null;
    }

    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return AmountChangedEntry.from((RegistryFriendlyByteBuf)buffer, ReactantStackEntry::from);
    }

    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof ReactantStackEntry) {
            ReactantStackEntry record = (ReactantStackEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        } else if (entry instanceof AmountChangedEntry) {
            AmountChangedEntry record = (AmountChangedEntry)entry;
            this.setClientSideValue(((ReactantStack)this.getValue()).copyWithAmount(record.amount()));
        }
    }

    @Nullable
    public ReactantStack defaultValue() {
        return ReactantStack.EMPTY;
    }

    private ReactantStackData(Supplier<ReactantStack> getter, Consumer<ReactantStack> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private ReactantStackData(Supplier<ReactantStack> getter) {
        super(getter);
        this._lastValue = ReactantStack.EMPTY;
    }

    private record ReactantStackEntry(ReactantStack value) implements ISyncedSetEntry
    {
        private static ReactantStackEntry from(RegistryFriendlyByteBuf buffer) {
            return new ReactantStackEntry(ReactantStack.createFrom((FriendlyByteBuf)buffer));
        }

        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeByte(1);
            this.value.writeTo((FriendlyByteBuf)buffer);
        }
    }
}

