/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.container.TurbineRedstonePortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor.TurbineSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor.TurbineSensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingHolder;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TurbineRedstonePortEntity
extends AbstractTurbineEntity
implements INeighborChangeListener,
ITickableMultiblockPart,
MenuProvider,
ISensorSettingHolder<ITurbineReader, ITurbineWriter, TurbineSensorType, TurbineSensorSetting> {
    private TurbineSensorSetting _setting = TurbineSensorSetting.DISABLED;
    private int _ticksSinceLastUpdate = 0;
    private boolean _isLit = false;
    private boolean _isExternallyPowered = false;
    private int _externalPowerLevel = 0;

    public TurbineRedstonePortEntity(BlockPos position, BlockState blockState) {
        super(Content.TileEntityTypes.TURBINE_REDSTONEPORT.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_REDSTONE_SENSOR, TurbineRedstonePortEntity::setNewSensorFromGUI).addServerHandler(CommonConstants.COMMAND_DISABLE_REDSTONE_SENSOR, TurbineRedstonePortEntity::disableSensorFromGUI).build((AbstractModBlockEntity)this));
    }

    public int getOutputSignalPower() {
        return ((TurbineSensorType)this.getSensorSetting().Sensor).isOutput() && this.isRedstoneActive() ? 15 : 0;
    }

    public boolean isLit() {
        return this._isLit;
    }

    public TurbineSensorSetting getSensorSetting() {
        return this._setting;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (!this.isConnected()) {
            return;
        }
        if (((TurbineSensorType)this.getSensorSetting().Sensor).isInput()) {
            this.getOutwardDirection().map(direction -> this.getRedstonePowerLevelFrom(this.getWorldPosition().relative(direction), (Direction)direction)).ifPresent(powerLevel -> {
                boolean nowPowered;
                boolean bl = nowPowered = powerLevel > 0;
                if (this._isExternallyPowered != nowPowered || this._externalPowerLevel != powerLevel) {
                    this._isExternallyPowered = nowPowered;
                    this._externalPowerLevel = powerLevel;
                    this.onRedstoneInputUpdated();
                    this.setChanged();
                    this.updateRedstoneStateAndNotify();
                }
            });
        } else {
            this._isExternallyPowered = false;
            this._externalPowerLevel = 0;
        }
    }

    public void onMultiblockServerTick() {
        if (!this.isConnected() || this._ticksSinceLastUpdate++ < (Integer)Config.COMMON.general.ticksPerRedstoneUpdate.get()) {
            return;
        }
        this.updateRedstoneStateAndNotify();
        this._ticksSinceLastUpdate = 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new TurbineRedstonePortContainer(windowId, inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        if (data.contains("setting")) {
            this._setting = TurbineSensorSetting.syncDataFrom(data.getCompound("setting"));
        }
        if (data.contains("lit")) {
            this._isLit = data.getBoolean("lit");
        }
        if (syncReason.isFullSync()) {
            this.updateRedstoneStateAndNotify();
        } else {
            this.markForRenderUpdate();
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        data.put("setting", (Tag)this.getSensorSetting().syncDataTo(new CompoundTag()));
        data.putBoolean("lit", this._isLit);
        return data;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this._isLit ? 1 : 0;
    }

    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    protected boolean isRedstoneActive() {
        TurbineSensorSetting settings = this.getSensorSetting();
        return ((TurbineSensorType)settings.Sensor).isOutput() ? this.getMultiblockController().map(arg_0 -> ((TurbineSensorSetting)settings).test(arg_0)).orElse(false) : this._isExternallyPowered && this.isConnected();
    }

    private void onRedstoneInputUpdated() {
        this.getMultiblockController().ifPresent(c -> this.getSensorSetting().inputAction((ITurbineWriter)c, this._isExternallyPowered, this._externalPowerLevel));
    }

    private void updateRedstoneStateAndNotify() {
        this.callOnLogicalServer(world -> {
            boolean oldLitState = this._isLit;
            if (oldLitState != this.updateLitState()) {
                world.updateNeighborsAt(this.getWorldPosition(), this.getBlockType());
            }
            this.notifyTileEntityUpdate();
        });
    }

    private void setNewSensorFromGUI(CompoundTag data) {
        this._setting = TurbineSensorSetting.syncDataFrom(data);
        this.getOutwardDirection().ifPresent(outward -> {
            BlockPos position = this.getWorldPosition();
            if (((TurbineSensorType)this._setting.Sensor).isInput()) {
                this._externalPowerLevel = this.getRedstonePowerLevelFrom(position.relative(outward), (Direction)outward);
                boolean bl = this._isExternallyPowered = this._externalPowerLevel > 0;
                if (!this._setting.Behavior.onPulse()) {
                    this.onRedstoneInputUpdated();
                }
            } else {
                this._isExternallyPowered = false;
                this._externalPowerLevel = 0;
            }
        });
        this.updateRedstoneStateAndNotify();
    }

    private void disableSensorFromGUI() {
        this._setting = TurbineSensorSetting.DISABLED;
        this.updateRedstoneStateAndNotify();
    }

    private boolean isReceivingRedstonePowerFrom(BlockPos position, Direction direction) {
        return (Boolean)this.mapPartWorld(w -> w.getBestNeighborSignal(position) > 0 || w.getSignal(position, direction) > 0, false);
    }

    private int getRedstonePowerLevelFrom(BlockPos position, Direction direction) {
        return (Integer)this.mapPartWorld(w -> Mth.clamp((int)w.getSignal(position, direction), (int)0, (int)15), 0);
    }

    protected boolean updateLitState() {
        this._isLit = ((TurbineSensorType)this.getSensorSetting().Sensor).isOutput() && this.isRedstoneActive() || this._isExternallyPowered;
        return this._isLit;
    }
}

